/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.commons.definitions.vocabulary.Role;
import eu.europeana.api.commons.nosql.service.ApiWriteLockService;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api.commons.service.authorization.BaseAuthorizationService;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.web.auth.Roles;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.stereotype.Component;

@Component
public class TranslationAuthorizationService
extends BaseAuthorizationService {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    private final TranslationConfig translationConfig;
    private final EuropeanaClientDetailsService clientDetailsService;

    @Autowired
    public TranslationAuthorizationService(TranslationConfig translationConfig, EuropeanaClientDetailsService clientDetailsService) {
        this.translationConfig = translationConfig;
        this.clientDetailsService = clientDetailsService;
    }

    protected ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    protected String getSignatureKey() {
        return this.translationConfig.getApiKeyPublicKey();
    }

    protected String getApiName() {
        return this.translationConfig.getAuthorizationApiName();
    }

    protected Role getRoleByName(String name) {
        return Roles.getRoleByName((String)name);
    }

    protected ApiWriteLockService getApiWriteLockService() {
        return null;
    }

    protected boolean isResourceAccessVerificationRequired(String operation) {
        return false;
    }

    protected boolean mustVerifyResourceAccessForRead() {
        return false;
    }
}

