/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api.translation.service.util.TranslationUtils;
import eu.europeana.api.translation.web.model.CachedTranslation;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisCacheService {
    private final RedisTemplate<String, CachedTranslation> redisTemplate;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public RedisCacheService(RedisTemplate<String, CachedTranslation> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void fillWithCachedTranslations(List<TranslationObj> translationObjects) {
        ArrayList<String> cacheKeys = new ArrayList<String>();
        ArrayList<TranslationObj> cacheableTranslations = new ArrayList<TranslationObj>();
        for (TranslationObj translationObj : translationObjects) {
            if (translationObj.getTranslation() != null || !this.isCacheable(translationObj) || translationObj.isTranslated()) continue;
            String redisKey = TranslationUtils.generateRedisKey((String)translationObj.getText(), (String)translationObj.getSourceLang(), (String)translationObj.getTargetLang(), null);
            cacheKeys.add(redisKey);
            cacheableTranslations.add(translationObj);
        }
        if (cacheKeys.isEmpty()) {
            return;
        }
        List redisResponse = this.redisTemplate.opsForValue().multiGet(cacheKeys);
        if (redisResponse == null || redisResponse.size() != cacheableTranslations.size()) {
            int redisSize = redisResponse == null ? 0 : redisResponse.size();
            this.logger.warn("Redis response size {} doesn't match the request size{}, for keys: {}", (Object)redisSize, (Object)cacheableTranslations.size(), cacheKeys);
            return;
        }
        for (int i = 0; i < redisResponse.size(); ++i) {
            this.updateFromCachedTranslation((TranslationObj)cacheableTranslations.get(i), (CachedTranslation)redisResponse.get(i), (String)cacheKeys.get(i));
        }
    }

    private void updateFromCachedTranslation(TranslationObj translationString, CachedTranslation cachedTranslation, String cacheKey) {
        if (cachedTranslation != null && cachedTranslation.getTranslation() != null) {
            translationString.setTranslation(cachedTranslation.getTranslation());
            translationString.setRetrievedFromCache(true);
            translationString.setCacheKey(cacheKey);
        }
    }

    private boolean isCacheable(TranslationObj translationObj) {
        return translationObj.getSourceLang() != null && !Objects.equals(translationObj.getTargetLang(), translationObj.getSourceLang()) && StringUtils.isNotEmpty((String)translationObj.getText());
    }

    private boolean hasTranslation(TranslationObj translationString) {
        return translationString.getTargetLang() != null && StringUtils.isNotEmpty((String)translationString.getTranslation());
    }

    public void store(List<TranslationObj> translationStrings) {
        HashMap<String, CachedTranslation> valueMap = new HashMap<String, CachedTranslation>();
        for (TranslationObj translObj : translationStrings) {
            if (!this.isCacheable(translObj) || !this.hasTranslation(translObj) || translObj.isRetrievedFromCache()) continue;
            String key = TranslationUtils.generateRedisKey((String)translObj.getText(), (String)translObj.getSourceLang(), (String)translObj.getTargetLang(), null);
            translObj.setCacheKey(key);
            valueMap.put(key, this.toCachedTranslation(translObj));
        }
        if (!valueMap.isEmpty()) {
            this.redisTemplate.opsForValue().multiSet(valueMap);
        }
    }

    private CachedTranslation toCachedTranslation(TranslationObj translationObj) {
        CachedTranslation cachedTranslation = new CachedTranslation();
        cachedTranslation.setOriginal(translationObj.getText());
        cachedTranslation.setTranslation(translationObj.getTranslation());
        return cachedTranslation;
    }

    public void deleteAll() {
        RedisConnectionFactory connFact = this.redisTemplate.getConnectionFactory();
        if (connFact != null) {
            connFact.getConnection().flushAll();
        }
    }
}

