/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.commons.error.EuropeanaI18nApiException;
import eu.europeana.api.translation.config.TranslationServiceProvider;
import eu.europeana.api.translation.definitions.model.LangDetectRequest;
import eu.europeana.api.translation.definitions.model.LangDetectResponse;
import eu.europeana.api.translation.definitions.model.LanguageDetectionObj;
import eu.europeana.api.translation.service.LanguageDetectionService;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import eu.europeana.api.translation.web.exception.ParamValidationException;
import eu.europeana.api.translation.web.service.BaseWebService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class LangDetectionWebService
extends BaseWebService {
    @Resource(name="translationServiceProvider")
    private TranslationServiceProvider translationServiceProvider;
    private final Logger logger = LogManager.getLogger(this.getClass());

    public LangDetectResponse detectLang(LangDetectRequest langDetectRequest) throws EuropeanaI18nApiException {
        List languageDetectionObjs = this.buildLangDetectionObjectList(langDetectRequest);
        LanguageDetectionService langDetectService = this.getLangDetectService(langDetectRequest);
        LanguageDetectionService fallback = this.getFallbackService(langDetectRequest);
        String serviceId = null;
        List filteredObjs = null;
        try {
            this.translationServiceProvider.getLanguageDetectionPreProcessor().detectLang(languageDetectionObjs);
            filteredObjs = languageDetectionObjs.stream().filter(to -> !to.isTranslated()).collect(Collectors.toList());
            langDetectService.detectLang(filteredObjs);
            serviceId = langDetectService.getServiceId();
        }
        catch (LanguageDetectionException originalError) {
            if (fallback == null) {
                this.throwApiException(originalError);
            }
            try {
                fallback.detectLang(filteredObjs);
                serviceId = fallback.getServiceId();
            }
            catch (LanguageDetectionException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Error when calling default service. ", (Throwable)e);
                }
                this.throwApiException(originalError);
            }
        }
        return new LangDetectResponse(this.getResults(languageDetectionObjs), serviceId);
    }

    private List<String> getResults(List<LanguageDetectionObj> languageDetectionObjs) {
        return languageDetectionObjs.stream().map(obj -> obj.getDetectedLang()).collect(Collectors.toList());
    }

    private LanguageDetectionService getFallbackService(LangDetectRequest langDetectRequest) throws ParamValidationException {
        if (langDetectRequest.getFallback() == null) {
            return null;
        }
        return this.getServiceInstance(langDetectRequest.getFallback(), langDetectRequest.getLang(), true);
    }

    private LanguageDetectionService getLangDetectService(LangDetectRequest langDetectRequest) throws ParamValidationException {
        String requestedServiceId = langDetectRequest.getService();
        String languageHint = langDetectRequest.getLang();
        if (requestedServiceId != null) {
            return this.getServiceInstance(requestedServiceId, languageHint);
        }
        String defaultServiceId = this.translationServiceProvider.getTranslationServicesConfig().getLangDetectConfig().getDefaultServiceId();
        return this.getServiceInstance(defaultServiceId, languageHint);
    }

    private LanguageDetectionService getServiceInstance(String requestedServiceId, String languageHint) throws ParamValidationException {
        return this.getServiceInstance(requestedServiceId, languageHint, false);
    }

    private LanguageDetectionService getServiceInstance(String requestedServiceId, String languageHint, boolean isFallbackService) throws ParamValidationException {
        LanguageDetectionService detectService = this.translationServiceProvider.getLangDetectionService(requestedServiceId);
        if (detectService == null) {
            String paramName = isFallbackService ? "fallback" : "service";
            String availableServices = this.translationServiceProvider.getAvailableLangDetectionServiceIds().toString();
            throw new ParamValidationException("Requested service is invalid:" + requestedServiceId, "error.invalid_param_value", "error.invalid_param_value", new String[]{paramName, requestedServiceId + " (available services: " + availableServices + ")"});
        }
        if (languageHint != null && !detectService.isSupported(languageHint)) {
            throw new ParamValidationException("Language hint not supported:" + languageHint, "error.invalid_param_value", "error.unsupported_language", new String[]{"lang", requestedServiceId});
        }
        return detectService;
    }

    public boolean isLangDetectionSupported(@NotNull String lang) {
        return this.translationServiceProvider.getTranslationServicesConfig().getLangDetectConfig().getSupported().contains(lang.toLowerCase(Locale.ENGLISH));
    }

    private List<LanguageDetectionObj> buildLangDetectionObjectList(LangDetectRequest langDetectRequest) {
        ArrayList<LanguageDetectionObj> detectionObjs = new ArrayList<LanguageDetectionObj>(langDetectRequest.getText().size());
        for (String inputText : langDetectRequest.getText()) {
            LanguageDetectionObj newLangDetectObj = new LanguageDetectionObj();
            if (langDetectRequest.getLang() != null) {
                newLangDetectObj.setHint(langDetectRequest.getLang());
            }
            newLangDetectObj.setText(inputText);
            newLangDetectObj.setTranslated(false);
            detectionObjs.add(newLangDetectObj);
        }
        return detectionObjs;
    }

    @PreDestroy
    public void close() {
        for (LanguageDetectionService service : this.translationServiceProvider.getLangDetectServices().values()) {
            service.close();
        }
    }
}

