/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.translation.definitions.model.LanguageDetectionObj;
import eu.europeana.api.translation.service.AbstractLanguageDetectionService;
import eu.europeana.api.translation.service.LanguageDetectionService;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import java.util.List;
import java.util.regex.Pattern;

public class LangDetectionPreProcessor
extends AbstractLanguageDetectionService
implements LanguageDetectionService {
    Pattern langDetectEligibleValuesPattern;

    public LangDetectionPreProcessor(Pattern langDetectEligibleValuesPattern) {
        this.langDetectEligibleValuesPattern = langDetectEligibleValuesPattern;
    }

    public boolean isSupported(String srcLang) {
        return true;
    }

    public String getServiceId() {
        return "TEXT_PROCESSOR";
    }

    public void detectLang(List<LanguageDetectionObj> languageDetectionObjs) throws LanguageDetectionException {
        for (LanguageDetectionObj obj : languageDetectionObjs) {
            if (this.langDetectEligibleValuesPattern.matcher(obj.getText()).find()) continue;
            obj.setTranslated(true);
        }
    }

    public void close() {
    }
}

