/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import eu.europeana.api.translation.definitions.model.TranslationCachingStats;
import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api.translation.service.AbstractTranslationService;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.exception.TranslationException;
import eu.europeana.api.translation.web.service.RedisCacheService;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CachedTranslationService
extends AbstractTranslationService {
    private final Logger logger = LogManager.getLogger(CachedTranslationService.class);
    private final RedisCacheService redisCacheService;
    private final TranslationService translationService;

    public CachedTranslationService(RedisCacheService redisCacheService, @NotNull TranslationService translationService) {
        this.redisCacheService = redisCacheService;
        this.translationService = translationService;
    }

    public String getServiceId() {
        return this.translationService.getServiceId();
    }

    public void setServiceId(String serviceId) {
    }

    public boolean isSupported(String srcLang, String trgLang) {
        return true;
    }

    private TranslationCachingStats computeTranslationCachingStats(List<TranslationObj> allTranslObjs) {
        int numLinesCached = 0;
        int numCharsCached = 0;
        int numLinesToBeTranslated = 0;
        int numCharsToBeTranslated = 0;
        for (TranslationObj translObj : allTranslObjs) {
            if (translObj.isRetrievedFromCache()) {
                ++numLinesCached;
                numCharsCached += translObj.getTranslation().length();
            }
            if (translObj.getTranslation() != null) continue;
            ++numLinesToBeTranslated;
            numCharsToBeTranslated += translObj.getText().length();
        }
        TranslationCachingStats stats = new TranslationCachingStats();
        stats.setNumLinesCached(numLinesCached);
        stats.setNumCharsCached(numCharsCached);
        stats.setNumLinesToBeTranslated(numLinesToBeTranslated);
        stats.setNumCharsToBeTranslated(numCharsToBeTranslated);
        return stats;
    }

    public void translate(List<TranslationObj> translationObjs) throws TranslationException {
        List<TranslationObj> toTranslate;
        this.processNonTranslatable(translationObjs);
        if (this.isCachingEnabled()) {
            this.redisCacheService.fillWithCachedTranslations(translationObjs);
        }
        if (this.logger.isInfoEnabled()) {
            TranslationCachingStats stats = this.computeTranslationCachingStats(translationObjs);
            this.logger.info("Tracking cache usage: numLinesCached={}, numCharsCached={}, numLinesToBeTranslated={}, numCharsToBeTranslated={}", (Object)stats.getNumLinesCached(), (Object)stats.getNumCharsCached(), (Object)stats.getNumLinesToBeTranslated(), (Object)stats.getNumCharsToBeTranslated());
        }
        if (!(toTranslate = translationObjs.stream().filter(t -> t.getTranslation() == null).toList()).isEmpty()) {
            this.translationService.translate(toTranslate);
            if (this.isCachingEnabled()) {
                this.redisCacheService.store(toTranslate);
            }
        }
    }

    public void close() {
    }

    public String getExternalServiceEndPoint() {
        return null;
    }

    private boolean isCachingEnabled() {
        return this.getRedisCacheService() != null;
    }

    public RedisCacheService getRedisCacheService() {
        return this.redisCacheService;
    }
}

