/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web.service;

import com.google.api.gax.rpc.ResourceExhaustedException;
import eu.europeana.api.commons.error.EuropeanaI18nApiException;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import eu.europeana.api.translation.service.exception.TranslationException;
import eu.europeana.api.translation.web.exception.ExternalServiceCallException;
import eu.europeana.api.translation.web.exception.GoogleResourceExhaustedException;
import org.springframework.http.HttpStatus;

public class BaseWebService {
    protected void throwApiException(LanguageDetectionException ex) throws EuropeanaI18nApiException {
        if (ex.getCause() instanceof ResourceExhaustedException) {
            throw new GoogleResourceExhaustedException(ex.getMessage(), "error.google_quota_limit_reached", "error.google_quota_limit_reached", null, (Throwable)ex);
        }
        throw new ExternalServiceCallException(ex.getMessage(), "error.detection.external_service_call", HttpStatus.GATEWAY_TIMEOUT, "error.detection.external_service_call", null, (Throwable)ex);
    }

    protected void throwApiException(TranslationException ex) throws EuropeanaI18nApiException {
        if (ex.getCause() instanceof ResourceExhaustedException) {
            throw new GoogleResourceExhaustedException("error.google_quota_limit_reached", null, "error.google_quota_limit_reached", null, (Throwable)ex);
        }
        throw new ExternalServiceCallException(ex.getMessage(), "error.translation.external_service_call", HttpStatus.GATEWAY_TIMEOUT, "error.translation.external_service_call", null, (Throwable)ex);
    }
}

