/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web;

import eu.europeana.api.translation.definitions.language.LanguagePair;
import eu.europeana.api.translation.definitions.model.TranslationRequest;
import eu.europeana.api.translation.definitions.model.TranslationResponse;
import eu.europeana.api.translation.web.BaseRest;
import eu.europeana.api.translation.web.exception.ParamValidationException;
import eu.europeana.api.translation.web.service.TranslationWebService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Translation endpoint", description="Perform text translation")
public class TranslationController
extends BaseRest {
    private final TranslationWebService translationService;

    @Autowired
    public TranslationController(TranslationWebService translationService) {
        this.translationService = translationService;
    }

    @Operation(summary="Text Translation")
    @PostMapping(value={"/translate"}, produces={"application/json;charset=utf-8", "application/json"})
    public ResponseEntity<String> translate(@RequestBody TranslationRequest translRequest, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("create", request);
        this.validateRequest(translRequest);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Translation request: {}", (Object)this.jsonLdSerializer.serializeObject((Object)translRequest));
        }
        TranslationResponse result = this.translationService.translate(translRequest);
        String resultJson = this.serialize((Object)result);
        return this.generateResponseEntity(request, resultJson);
    }

    private void validateRequest(TranslationRequest translationRequest) throws ParamValidationException {
        if (translationRequest.getText() == null || this.containsNullValues(translationRequest.getText())) {
            throw new ParamValidationException(null, "error.mandatory_param_empty", "error.mandatory_param_empty", new String[]{"text"});
        }
        if (StringUtils.isEmpty((CharSequence)translationRequest.getTarget())) {
            throw new ParamValidationException(null, "error.mandatory_param_empty", "error.mandatory_param_empty", new String[]{"target"});
        }
        LanguagePair languagePair = new LanguagePair(translationRequest.getSource(), translationRequest.getTarget());
        if (!this.translationService.isTranslationSupported(languagePair)) {
            throw new ParamValidationException(null, "error.mandatory_param_empty", "error.invalid_param_value", new String[]{LanguagePair.generateKey((String)"source", (String)"target"), languagePair.toString()});
        }
    }
}

