/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web;

import eu.europeana.api.translation.definitions.model.LangDetectRequest;
import eu.europeana.api.translation.definitions.model.LangDetectResponse;
import eu.europeana.api.translation.web.BaseRest;
import eu.europeana.api.translation.web.exception.ParamValidationException;
import eu.europeana.api.translation.web.service.LangDetectionWebService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="Language Detection endoints", description="Perform language detection")
public class LangDetectionController
extends BaseRest {
    private final LangDetectionWebService langDetectionService;

    public LangDetectionController(@Autowired LangDetectionWebService langDetectionService) {
        this.langDetectionService = langDetectionService;
    }

    @Operation(summary="Language detection")
    @PostMapping(value={"/detect"}, produces={"application/json;charset=utf-8", "application/json"})
    public ResponseEntity<String> detectLang(@RequestBody LangDetectRequest langDetectRequest, HttpServletRequest request) throws Exception {
        this.verifyWriteAccess("create", request);
        this.validateRequest(langDetectRequest);
        LangDetectResponse result = this.langDetectionService.detectLang(langDetectRequest);
        String resultJson = this.serialize((Object)result);
        return this.generateResponseEntity(request, resultJson);
    }

    private void validateRequest(LangDetectRequest langDetectRequest) throws ParamValidationException {
        if (langDetectRequest.getText() == null || this.containsNullValues(langDetectRequest.getText())) {
            throw new ParamValidationException(null, "error.mandatory_param_empty", "error.mandatory_param_empty", new String[]{"text"});
        }
        if (langDetectRequest.getLang() != null && !this.langDetectionService.isLangDetectionSupported(langDetectRequest.getLang())) {
            throw new ParamValidationException(null, "error.invalid_param_value", "error.invalid_param_value", new String[]{"lang", langDetectRequest.getLang()});
        }
    }
}

