/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web;

import eu.europeana.api.commons.definitions.utils.LoggingUtils;
import eu.europeana.api.translation.web.model.CachedTranslation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="ETranslation callback controller", description="Receives the eTranslation response")
public class ETranslationCallbackController {
    private static final Logger LOGGER = LogManager.getLogger(ETranslationCallbackController.class);
    RedisTemplate<String, CachedTranslation> redisTemplate;

    @Autowired
    public ETranslationCallbackController(RedisTemplate<String, CachedTranslation> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Tag(description="ETranslation callback endpoint", name="eTranslationCallback")
    @PostMapping(value={"/etranslation/callback"})
    public void eTranslationCallbackPost(@RequestParam(value="target-language", required=false) String targetLanguage, @RequestParam(value="translated-text", required=false) String translatedTextSnippet, @RequestParam(value="request-id", required=true) String requestId, @RequestParam(value="external-reference", required=true) String externalReference, @RequestBody(required=false) String body) {
        String translations;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("eTranslation callback has been received with the request-id: {}, and the external-reference: {}", (Object)LoggingUtils.sanitizeUserInput((String)requestId), (Object)LoggingUtils.sanitizeUserInput((String)externalReference));
        }
        String string = translations = translatedTextSnippet == null ? body : translatedTextSnippet;
        if (externalReference != null && translations != null) {
            this.redisTemplate.convertAndSend(externalReference, (Object)translations);
        }
    }

    @Tag(description="ETranslation callback endpoint", name="eTranslationCallback")
    @GetMapping(value={"/etranslation/callback"})
    @Deprecated(since="begiging ...")
    public ResponseEntity<String> eTranslationCallbackGet(@RequestParam(value="target-language", required=false) String targetLanguage, @RequestParam(value="translated-text", required=false) String translatedTextSnippet, @RequestParam(value="request-id", required=false) String requestId, @RequestParam(value="external-reference", required=false) String externalReference, @RequestParam(value="timeout", required=false) Integer timeout) throws InterruptedException {
        if (timeout != null && timeout > 0) {
            long SECONDS_MILIS = 1000L;
            Thread.sleep((long)timeout.intValue() * 1000L);
            return ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).build();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("eTranslation callback has been received with the request-id: {}, and the external-reference: {}", (Object)LoggingUtils.sanitizeUserInput((String)requestId), (Object)LoggingUtils.sanitizeUserInput((String)externalReference));
        }
        if (externalReference != null && translatedTextSnippet != null) {
            this.redisTemplate.convertAndSend(externalReference, (Object)translatedTextSnippet);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).build();
    }

    @Tag(description="ETranslation error callback endpoint", name="eTranslationErrorCallback")
    @PostMapping(value={"/etranslation/error-callback"})
    public void eTranslationErrorCallbackPost(@RequestParam(value="error-code", required=false) String errorCode, @RequestParam(value="error-message", required=false) String errorMessage, @RequestParam(value="target-languages", required=false) String targetLanguages, @RequestParam(value="request-id", required=false) String requestId, @RequestParam(value="external-reference", required=false) String externalReference, @RequestBody(required=false) String body) {
        this.handleErroCallback(errorCode, errorMessage, requestId, externalReference);
    }

    private void handleErroCallback(String errorCode, String errorMessage, String requestId, String externalReference) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("eTranslation error callback has been received with the following parameters: error-code: {},error-message: {}, request-id: {}, external-reference: {}", (Object)LoggingUtils.sanitizeUserInput((String)errorCode), (Object)LoggingUtils.sanitizeUserInput((String)errorMessage), (Object)LoggingUtils.sanitizeUserInput((String)requestId), (Object)LoggingUtils.sanitizeUserInput((String)externalReference));
        }
        if (externalReference != null) {
            this.redisTemplate.convertAndSend(externalReference, (Object)String.format("%s: error-code=%s, error-message=%s", "eTranslationErrorCallback", errorCode, errorMessage));
        }
    }

    @Tag(description="ETranslation error callback endpoint", name="eTranslationErrorCallback")
    @GetMapping(value={"/etranslation/error-callback"})
    public void eTranslationErrorCallbackGet(@RequestParam(value="error-code", required=false) String errorCode, @RequestParam(value="error-message", required=false) String errorMessage, @RequestParam(value="target-languages", required=false) String targetLanguages, @RequestParam(value="request-id", required=false) String requestId, @RequestParam(value="external-reference", required=false) String externalReference, @RequestBody(required=false) String body) {
        this.handleErroCallback(errorCode, errorMessage, requestId, externalReference);
    }
}

