/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.web;

import eu.europeana.api.commons.error.EuropeanaApiException;
import eu.europeana.api.commons.web.controller.BaseRestController;
import eu.europeana.api.commons.web.exception.ApplicationAuthenticationException;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.serialization.JsonLdSerializer;
import eu.europeana.api.translation.web.service.RequestPathMethodService;
import eu.europeana.api.translation.web.service.TranslationAuthorizationService;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.info.BuildProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;

public abstract class BaseRest
extends BaseRestController {
    @Autowired
    private TranslationAuthorizationService translAuthorizationService;
    @Autowired
    protected BuildProperties translationBuildInfo;
    @Autowired
    protected JsonLdSerializer jsonLdSerializer;
    @Autowired
    private RequestPathMethodService requestMethodService;
    @Autowired
    protected TranslationConfig translationConfig;
    protected Logger logger = LogManager.getLogger(this.getClass());

    protected TranslationAuthorizationService getAuthorizationService() {
        return this.translAuthorizationService;
    }

    protected String getApiVersion() {
        return this.translationBuildInfo.getVersion();
    }

    protected String serialize(Object result) throws EuropeanaApiException {
        String responseBody = null;
        try {
            responseBody = this.jsonLdSerializer.serializeObject(result);
        }
        catch (IOException e) {
            throw new EuropeanaApiException("Error serializing results.", (Throwable)e);
        }
        return responseBody;
    }

    protected ResponseEntity<String> generateResponseEntity(HttpServletRequest request, String result) throws EuropeanaApiException {
        HttpHeaders headers = this.createAllowHeader(request);
        headers.add("Content-Type", "application/json;charset=utf-8");
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).headers(headers)).body((Object)result);
    }

    protected HttpHeaders createAllowHeader(HttpServletRequest request) {
        String allowHeaderValue;
        HttpHeaders headers = new HttpHeaders();
        Optional methodsForRequestPattern = this.requestMethodService.getMethodsForRequestPattern(request);
        if (methodsForRequestPattern.isEmpty()) {
            this.logger.warn("Could not find other matching methods for {}. Using current request method in Allow header", (Object)request.getRequestURL());
            allowHeaderValue = request.getMethod();
        } else {
            allowHeaderValue = (String)methodsForRequestPattern.get();
        }
        headers.add("Allow", allowHeaderValue);
        return headers;
    }

    protected ResponseEntity<String> noContentResponse(HttpServletRequest request) {
        return ResponseEntity.noContent().headers(this.createAllowHeader(request)).build();
    }

    public Authentication verifyWriteAccess(String operation, HttpServletRequest request) throws ApplicationAuthenticationException {
        if (this.translationConfig.isAuthWriteEnabled()) {
            return super.verifyWriteAccess(operation, request);
        }
        return null;
    }

    public Authentication verifyReadAccess(HttpServletRequest request) throws ApplicationAuthenticationException {
        if (this.translationConfig.isAuthReadEnabled()) {
            return super.verifyReadAccess(request);
        }
        return null;
    }

    protected boolean containsNullValues(List<String> texts) {
        for (String text : texts) {
            if (text != null) continue;
            return true;
        }
        return false;
    }
}

