/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.serialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class JsonLdSerializer {
    private final ObjectMapper mapper;
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Autowired
    public JsonLdSerializer(@Qualifier(value="translationJsonMapper") ObjectMapper objectMapper) {
        this.mapper = objectMapper.copy();
        SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
        this.mapper.setDateFormat((DateFormat)df);
    }

    public String serializeObject(Object obj) throws IOException {
        return this.mapper.writeValueAsString(obj);
    }
}

