/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config.services;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import eu.europeana.api.translation.definitions.language.LanguagePair;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"source", "target", "service"})
public class TranslationMappingCfg {
    private List<String> srcLang;
    private List<String> trgLang;
    private String serviceId;

    @JsonGetter(value="source")
    public List<String> getSrcLang() {
        return this.srcLang;
    }

    @JsonSetter(value="source")
    public void setSrcLang(List<String> srcLang) {
        this.srcLang = srcLang;
    }

    @JsonGetter(value="target")
    public List<String> getTrgLang() {
        return this.trgLang;
    }

    @JsonSetter(value="target")
    public void setTrgLang(List<String> trgLang) {
        this.trgLang = trgLang;
    }

    @JsonGetter(value="service")
    public String getServiceId() {
        return this.serviceId;
    }

    @JsonSetter(value="service")
    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean isSupported(LanguagePair languagePair) {
        return this.getTrgLang().contains(languagePair.getTargetLang()) && this.getSrcLang().contains(languagePair.getTargetLang());
    }
}

