/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    MediaType jsonLdMediaType = MediaType.valueOf((String)"application/ld+json");
    Map<String, MediaType> mediaTypesMaping = new HashMap();

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"*"}).allowedHeaders(new String[]{"*"}).allowCredentials(false).exposedHeaders(new String[]{"Allow"}).maxAge(1000L);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorPathExtension(true);
        configurer.useRegisteredExtensionsOnly(true);
        configurer.mediaTypes(this.getMediaTypesMapping());
        configurer.defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
    }

    private Map<String, MediaType> getMediaTypesMapping() {
        this.mediaTypesMaping.put("json", MediaType.APPLICATION_JSON);
        this.mediaTypesMaping.put("jsonld", this.jsonLdMediaType);
        this.mediaTypesMaping.put(MediaType.TEXT_HTML.getSubtype(), MediaType.TEXT_HTML);
        this.mediaTypesMaping.put(MediaType.TEXT_PLAIN.getSubtype(), MediaType.TEXT_PLAIN);
        return this.mediaTypesMaping;
    }
}

