/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.translation.config.AbstractServiceInstantiationUtils;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.config.services.DetectCfg;
import eu.europeana.api.translation.config.services.DetectServiceCfg;
import eu.europeana.api.translation.config.services.TranslationLangPairCfg;
import eu.europeana.api.translation.config.services.TranslationMappingCfg;
import eu.europeana.api.translation.config.services.TranslationServiceCfg;
import eu.europeana.api.translation.config.services.TranslationServicesConfiguration;
import eu.europeana.api.translation.definitions.language.LanguagePair;
import eu.europeana.api.translation.service.LanguageDetectionService;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.etranslation.ETranslationTranslationService;
import eu.europeana.api.translation.service.exception.LangDetectionServiceConfigurationException;
import eu.europeana.api.translation.service.exception.TranslationException;
import eu.europeana.api.translation.service.exception.TranslationServiceConfigurationException;
import eu.europeana.api.translation.service.google.GoogleTranslationService;
import eu.europeana.api.translation.service.google.GoogleTranslationServiceClientWrapper;
import eu.europeana.api.translation.service.pangeanic.PangeanicLangDetectService;
import eu.europeana.api.translation.service.pangeanic.PangeanicTranslationService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;

public class TranslationServiceProvider
extends AbstractServiceInstantiationUtils {
    public static final String DEFAULT_SERVICE_CONFIG_FILE = "/translation_service_configuration.json";
    private static final String FILE_PANGEANIC_LANGUAGE_THRESHOLDS = "pangeanic_language_thresholds.properties";
    private final Logger logger = LogManager.getLogger(TranslationServiceProvider.class);
    private final String serviceConfigLocation;
    private final File serviceConfigFile;
    @Autowired
    ApplicationContext applicationContext;
    @Resource(name="translationConfig")
    TranslationConfig translationConfig;
    @Resource(name="langDetectPreProcessorService")
    LanguageDetectionService languageDetectionPreProcessor;
    @Resource(name="translationPreProcessorService")
    TranslationService translationServicePreProcessor;
    @Resource(name="redisCacheMessageListenerContainer")
    RedisMessageListenerContainer redisMessageListenerContainer;
    private GoogleTranslationServiceClientWrapper googleTranslationServiceClientWrapper;
    Map<String, LanguageDetectionService> langDetectServices = new ConcurrentHashMap();
    Map<String, TranslationService> translationServices = new ConcurrentHashMap();
    Map<String, TranslationService> langMappings4TranslateServices = new ConcurrentHashMap();
    TranslationServicesConfiguration translationServicesConfig;

    public TranslationServiceProvider() {
        this(DEFAULT_SERVICE_CONFIG_FILE);
    }

    public TranslationServiceProvider(String serviceConfigLocation) {
        this.serviceConfigLocation = serviceConfigLocation;
        this.serviceConfigFile = null;
    }

    public TranslationServiceProvider(File serviceConfigFile) {
        this.serviceConfigFile = serviceConfigFile;
        this.serviceConfigLocation = null;
    }

    public Optional<DetectServiceCfg> getLangDetectServiceDefinition(String beanName) {
        if (this.translationServicesConfig == null || this.translationServicesConfig.getLangDetectConfig() == null) {
            return Optional.empty();
        }
        List serviceDefinitions = this.translationServicesConfig.getLangDetectConfig().getServiceDefinition();
        return serviceDefinitions.stream().filter(sd -> beanName.equals(sd.getId())).findFirst();
    }

    public Map<String, LanguageDetectionService> getLangDetectServices() {
        return this.langDetectServices;
    }

    public Map<String, TranslationService> getTranslationServices() {
        return this.translationServices;
    }

    public void initTranslationServicesFromConfiguration() throws TranslationServiceConfigurationException, LangDetectionServiceConfigurationException {
        this.readServiceConfigurations();
        this.validateAndInitServices();
    }

    void readServiceConfigurations() throws TranslationServiceConfigurationException {
        if (Objects.nonNull(this.serviceConfigFile)) {
            this.readServiceConfigurationsFromConfigFile();
        } else {
            this.readServiceConfigurationsFromClassPath();
        }
    }

    private void readServiceConfigurationsFromClassPath() throws TranslationServiceConfigurationException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(this.getServiceConfigLocation());){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            this.parseTranslationServicesConfig(reader);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Successfully loaded service configurations from classpath resources.");
            }
        }
        catch (IOException e) {
            throw new TranslationServiceConfigurationException("Cannot read service configurations from classpath resources!", (Throwable)e);
        }
    }

    private void readServiceConfigurationsFromConfigFile() throws TranslationServiceConfigurationException {
        try (BufferedReader input = Files.newBufferedReader(this.serviceConfigFile.toPath());){
            this.parseTranslationServicesConfig(input);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Successfully loaded service configurations from external config file.");
            }
        }
        catch (IOException e) {
            throw new TranslationServiceConfigurationException("Cannot load service configurations from external config file: " + String.valueOf(this.serviceConfigFile.toPath()), (Throwable)e);
        }
    }

    private void parseTranslationServicesConfig(BufferedReader reader) throws JsonProcessingException {
        String content = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        this.translationServicesConfig = (TranslationServicesConfiguration)new ObjectMapper().readValue(content, TranslationServicesConfiguration.class);
    }

    private void validateAndInitServices() throws TranslationServiceConfigurationException, LangDetectionServiceConfigurationException {
        this.initLangDetectionServices();
        this.validateDefaultLangDetectServiceConfig();
        this.validateAndInitFromTranslationServiceCfg();
    }

    private void validateAndInitFromTranslationServiceCfg() throws TranslationServiceConfigurationException {
        this.initTranslationServices();
        this.validateDefaultTranslationService();
        this.validateAndInitLanguageMappings();
        this.validateSupportedLanguagePairs();
    }

    private void validateSupportedLanguagePairs() throws TranslationServiceConfigurationException {
        List supportedLanguagePairs = this.translationServicesConfig.getTranslationConfig().getSupported();
        for (TranslationLangPairCfg langPair : supportedLanguagePairs) {
            for (String srcLang : langPair.getSrcLang()) {
                for (String trgLang : langPair.getTargetLang()) {
                    this.validateSupportedLanguagePair(srcLang, trgLang);
                }
            }
        }
    }

    private void validateSupportedLanguagePair(@NotNull String srcLang, @NotNull String trgLang) throws TranslationServiceConfigurationException {
        boolean isSupported = this.getLangMappings4TranslateServices().containsKey(LanguagePair.generateKey((String)srcLang, (String)trgLang));
        if (!isSupported && this.getDefaultTranslationService() != null) {
            isSupported = this.getDefaultTranslationService().isSupported(srcLang, trgLang);
        }
        if (!isSupported) {
            throw new TranslationServiceConfigurationException("The translation services do not support all languages declared in the supported section.");
        }
    }

    private void validateDefaultTranslationService() throws TranslationServiceConfigurationException {
        if (!this.getTranslationServices().containsKey(this.getDefaultTranslationServiceId())) {
            throw new TranslationServiceConfigurationException("Translation default service id is invalid.");
        }
    }

    private String getDefaultTranslationServiceId() {
        return this.translationServicesConfig.getTranslationConfig().getDefaultServiceId();
    }

    private TranslationService getDefaultTranslationService() {
        return this.getTranslationServices().getOrDefault(this.getDefaultTranslationServiceId(), null);
    }

    private void initTranslationServices() throws TranslationServiceConfigurationException {
        for (TranslationServiceCfg translServiceConfig : this.translationServicesConfig.getTranslationConfig().getServices()) {
            String serviceId = translServiceConfig.getId();
            if (this.getAvailableTranslationServiceIds().contains(serviceId)) {
                throw new TranslationServiceConfigurationException("Duplicate service id in the translation config.");
            }
            TranslationService translService = this.createServiceInstance(translServiceConfig);
            this.initTranslationService(translService);
            this.getTranslationServices().put(translService.getServiceId(), translService);
        }
    }

    private void initTranslationService(TranslationService translService) throws TranslationServiceConfigurationException {
        if (translService.getClass().equals(PangeanicTranslationService.class)) {
            ((PangeanicTranslationService)translService).init(this.translationConfig.getPangeanicTranslateEndpoint(), new PangeanicLangDetectService(this.translationConfig.getPangeanicDetectEndpoint()), this.loadPangeanicTranslationThresholds(FILE_PANGEANIC_LANGUAGE_THRESHOLDS));
        } else {
            if (translService.getClass().equals(GoogleTranslationService.class)) {
                try {
                    ((GoogleTranslationService)translService).init(this.translationConfig.getGoogleTranslateProjectId(), this.getGoogleTranslationServiceClientWrapper());
                }
                catch (IOException e) {
                    throw new TranslationServiceConfigurationException("Cannot instantiate google translation client wrapper!", (Throwable)e);
                }
            }
            if (translService.getClass().equals(ETranslationTranslationService.class)) {
                try {
                    ((ETranslationTranslationService)translService).init(this.translationConfig.getEtranslationBaseUrl(), this.translationConfig.getEtranslationDomain(), this.translationConfig.getTranslationApiBaseUrl(), this.translationConfig.getEtranslationMaxWaitMillisec(), this.translationConfig.getEtranslationUsername(), this.translationConfig.getEtranslationPassword(), this.redisMessageListenerContainer);
                }
                catch (TranslationException e) {
                    throw new TranslationServiceConfigurationException("Cannot instantiate google translation client wrapper!", (Throwable)e);
                }
            }
        }
    }

    private void validateAndInitLanguageMappings() throws TranslationServiceConfigurationException {
        if (this.translationServicesConfig.getTranslationConfig().getMappings() == null) {
            return;
        }
        for (TranslationMappingCfg translMapping : this.translationServicesConfig.getTranslationConfig().getMappings()) {
            String serviceId = translMapping.getServiceId();
            TranslationService translationService = this.verifyRegisteredService(serviceId);
            for (String srcLang : translMapping.getSrcLang()) {
                for (String trgLang : translMapping.getTrgLang()) {
                    this.registerLanguageMapping(translationService, srcLang, trgLang);
                }
            }
        }
    }

    private void registerLanguageMapping(TranslationService translationService, String srcLang, String trgLang) throws TranslationServiceConfigurationException {
        if (srcLang.equals(trgLang)) {
            throw new TranslationServiceConfigurationException("Invalid language mapping in service configurations! Target language must be different from the source language: " + srcLang + " for service with id: " + translationService.getServiceId());
        }
        String key = LanguagePair.generateKey((String)srcLang, (String)trgLang);
        if (!translationService.isSupported(srcLang, trgLang)) {
            throw new TranslationServiceConfigurationException("Invalid service configuration! Translation service: " + translationService.getServiceId() + ", does not support the language pair: " + key + ", declared in the mappings section.");
        }
        if (this.getLangMappings4TranslateServices().containsKey(key)) {
            throw new TranslationServiceConfigurationException("Dupplicate language mapping in service configurations for key: " + key);
        }
        this.getLangMappings4TranslateServices().put(key, translationService);
    }

    private TranslationService verifyRegisteredService(String serviceId) throws TranslationServiceConfigurationException {
        boolean isServiceBeanRegistered = this.getTranslationServices().containsKey(serviceId);
        if (!isServiceBeanRegistered) {
            throw new TranslationServiceConfigurationException("Translation service id declared in the mappings is invalid.");
        }
        return (TranslationService)this.getTranslationServices().get(serviceId);
    }

    private void validateDefaultLangDetectServiceConfig() throws LangDetectionServiceConfigurationException {
        String defaultServiceId = this.translationServicesConfig.getLangDetectConfig().getDefaultServiceId();
        if (!this.getAvailableLangDetectionServiceIds().contains(defaultServiceId)) {
            throw new LangDetectionServiceConfigurationException("Language detection default service id is invalid.");
        }
        LanguageDetectionService defaultLanguageDetectionService = (LanguageDetectionService)this.getLangDetectServices().get(defaultServiceId);
        for (String supportedLang : this.translationServicesConfig.getLangDetectConfig().getSupported()) {
            if (defaultLanguageDetectionService.isSupported(supportedLang)) continue;
            throw new LangDetectionServiceConfigurationException("The default language detection service does not support language: " + supportedLang + ", declared in the supported section");
        }
    }

    private void initLangDetectionServices() throws LangDetectionServiceConfigurationException {
        for (DetectServiceCfg detectServiceCfg : this.translationServicesConfig.getLangDetectConfig().getServiceDefinition()) {
            if (this.getAvailableLangDetectionServiceIds().contains(detectServiceCfg.getId())) {
                throw new LangDetectionServiceConfigurationException("Duplicate service id in the language detection config.");
            }
            LanguageDetectionService detectService = this.createServiceInstance(detectServiceCfg, this.translationServicesConfig.getLangDetectConfig());
            this.initReferencedServices(detectService, detectServiceCfg, this.translationServicesConfig.getLangDetectConfig());
            this.getLangDetectServices().put(detectServiceCfg.getId(), detectService);
        }
    }

    private void initReferencedServices(LanguageDetectionService detectService, DetectServiceCfg detectServiceCfg, DetectCfg detectCfg) throws LangDetectionServiceConfigurationException {
        if (detectServiceCfg.getReferencedServices() != null) {
            ArrayList<LanguageDetectionService> referencedServices = new ArrayList<LanguageDetectionService>(detectServiceCfg.getReferencedServices().size());
            for (DetectServiceCfg referencedServiceCfg : detectServiceCfg.getReferencedServices()) {
                referencedServices.add(this.createServiceInstance(referencedServiceCfg, detectCfg));
            }
            detectService.setReferencedServices(referencedServices);
        }
    }

    public String getServiceConfigLocation() {
        return this.serviceConfigLocation;
    }

    public Map<String, TranslationService> getLangMappings4TranslateServices() {
        return this.langMappings4TranslateServices;
    }

    public LanguageDetectionService getLanguageDetectionPreProcessor() {
        return this.languageDetectionPreProcessor;
    }

    public TranslationService getTranslationServicePreProcessor() {
        return this.translationServicePreProcessor;
    }

    TranslationConfig getTranslationConfig() {
        return this.translationConfig;
    }

    public TranslationServicesConfiguration getTranslationServicesConfig() {
        return this.translationServicesConfig;
    }

    GoogleTranslationServiceClientWrapper getGoogleTranslationServiceClientWrapper() throws IOException {
        if (this.googleTranslationServiceClientWrapper == null) {
            this.googleTranslationServiceClientWrapper = AbstractServiceInstantiationUtils.createGoogleTranslationClientWrapperInstance((TranslationConfig)this.translationConfig);
        }
        return this.googleTranslationServiceClientWrapper;
    }

    public LanguageDetectionService getLangDetectionService(String requestedServiceId) {
        return (LanguageDetectionService)this.getLangDetectServices().get(requestedServiceId);
    }

    public TranslationService getTranslationService(String requestedServiceId) {
        return (TranslationService)this.getTranslationServices().get(requestedServiceId);
    }

    public Set<String> getAvailableLangDetectionServiceIds() {
        return this.getLangDetectServices().keySet();
    }

    public Set<String> getAvailableTranslationServiceIds() {
        return this.getTranslationServices().keySet();
    }
}

