/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration(value="translationConfig")
@PropertySources(value={@PropertySource(value={"classpath:translation.properties"}), @PropertySource(value={"translation.user.properties"}, ignoreResourceNotFound=true)})
public class TranslationConfig {
    public static final String CONFIG_FOLDER = "/opt/app/config";
    @Value(value="${translation.api.baseUrl:#{null}}")
    private String translationApiBaseUrl;
    @Value(value="${europeana.apikey.jwttoken.signaturekey:}")
    private String apiKeyPublicKey;
    @Value(value="${authorization.api.name: translations}")
    private String authorizationApiName;
    @Value(value="${auth.read.enabled: true}")
    private boolean authReadEnabled;
    @Value(value="${auth.write.enabled: true}")
    private boolean authWriteEnabled;
    @Value(value="${europeana.apikey.serviceurl:}")
    private String apiKeyUrl;
    @Value(value="${translation.pangeanic.endpoint.detect}")
    private String pangeanicDetectEndpoint;
    @Value(value="${translation.pangeanic.endpoint.translate}")
    private String pangeanicTranslateEndpoint;
    @Value(value="${translation.google.projectId:}")
    private String googleTranslateProjectId;
    @Value(value="${translation.google.usehttpclient: false}")
    private boolean useGoogleHttpClient;
    @Value(value="${redis.connection.url:}")
    private String redisConnectionUrl;
    @Value(value="${truststore.path:}")
    private String truststorePath;
    @Value(value="${truststore.password:}")
    private String truststorePass;
    @Value(value="${translation.eTranslation.username:#{null}}")
    private String etranslationUsername;
    @Value(value="${translation.eTranslation.password:#{null}}")
    private String etranslationPassword;
    @Value(value="${translation.eTranslation.domain:#{null}}")
    private String etranslationDomain;
    @Value(value="${translation.eTranslation.maxWaitMillisec:30000}")
    private int etranslationMaxWaitMillisec;
    @Value(value="${translation.eTranslation.baseUrl:#{null}}")
    private String etranslationBaseUrl;
    @Value(value="${translation.eTranslation.truncate:#{null}}")
    private boolean etranslationTruncate;
    @Value(value="${translation.dummy.services:false}")
    private boolean useDummyServices;

    public String getTranslationApiBaseUrl() {
        return this.translationApiBaseUrl;
    }

    public String getApiKeyPublicKey() {
        return this.apiKeyPublicKey;
    }

    public String getAuthorizationApiName() {
        return this.authorizationApiName;
    }

    public boolean isAuthReadEnabled() {
        return this.authReadEnabled;
    }

    public boolean isAuthWriteEnabled() {
        return this.authWriteEnabled;
    }

    public String getApiKeyUrl() {
        return this.apiKeyUrl;
    }

    public String getPangeanicDetectEndpoint() {
        return this.pangeanicDetectEndpoint;
    }

    public String getPangeanicTranslateEndpoint() {
        return this.pangeanicTranslateEndpoint;
    }

    public String getGoogleTranslateProjectId() {
        return this.googleTranslateProjectId;
    }

    public void setTranslationGoogleProjectId(String googleTranslateProjectId) {
        this.googleTranslateProjectId = googleTranslateProjectId;
    }

    public void verifyRequiredProperties() {
        ArrayList<String> missingProps = new ArrayList<String>();
        if (this.isAuthReadEnabled() && StringUtils.isBlank((CharSequence)this.getApiKeyUrl())) {
            missingProps.add("europeana.apikey.jwttoken.signaturekey");
        }
        if (this.isAuthWriteEnabled() && StringUtils.isBlank((CharSequence)this.getApiKeyPublicKey())) {
            missingProps.add("europeana.apikey.serviceurl");
        }
        if (!missingProps.isEmpty()) {
            throw new IllegalStateException(String.format("The following config properties are not set: %s", String.join((CharSequence)"\n", missingProps)));
        }
    }

    public boolean useGoogleHttpClient() {
        return this.useGoogleHttpClient;
    }

    public String getRedisConnectionUrl() {
        return this.redisConnectionUrl;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePass() {
        return this.truststorePass;
    }

    public boolean isUseDummyServices() {
        return this.useDummyServices;
    }

    public String getConfigFolder() {
        return CONFIG_FOLDER;
    }

    public String getEtranslationUsername() {
        return this.etranslationUsername;
    }

    public String getEtranslationPassword() {
        return this.etranslationPassword;
    }

    public String getEtranslationDomain() {
        return this.etranslationDomain;
    }

    public int getEtranslationMaxWaitMillisec() {
        return this.etranslationMaxWaitMillisec;
    }

    public String getEtranslationBaseUrl() {
        return this.etranslationBaseUrl;
    }

    public boolean isEtranslationTruncate() {
        return this.etranslationTruncate;
    }

    public File getConfigFile(String configFile) {
        return new File(this.getConfigFolder(), FilenameUtils.getName((String)configFile));
    }
}

