/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import eu.europeana.api.commons.config.i18n.I18nService;
import eu.europeana.api.commons.config.i18n.I18nServiceImpl;
import eu.europeana.api.commons.oauth2.service.impl.EuropeanaClientDetailsService;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.config.TranslationServiceProvider;
import eu.europeana.api.translation.service.exception.LangDetectionServiceConfigurationException;
import eu.europeana.api.translation.service.exception.TranslationServiceConfigurationException;
import eu.europeana.api.translation.web.exception.AppConfigurationException;
import eu.europeana.api.translation.web.model.CachedTranslation;
import eu.europeana.api.translation.web.service.LangDetectionPreProcessor;
import eu.europeana.api.translation.web.service.RedisCacheService;
import eu.europeana.api.translation.web.service.TranslationPreProcessor;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.SslOptions;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

@Configuration
@PropertySource(value={"translation.user.properties"}, ignoreResourceNotFound=true)
public class TranslationApiAutoconfig
implements ApplicationListener<ApplicationStartedEvent> {
    private final Logger logger = LogManager.getLogger(TranslationApiAutoconfig.class);
    private static final String PATTERN = "\\p{IsAlphabetic}{2,}";
    private static final Pattern IsAlphabetic = Pattern.compile("\\p{IsAlphabetic}{2,}");
    private final TranslationConfig translationConfig;
    TranslationServiceProvider translationServiceProvider;
    @Value(value="${translation.service.config.file:}")
    private String serviceConfigFile;

    public TranslationApiAutoconfig(@Autowired TranslationConfig translationConfig) {
        this.translationConfig = translationConfig;
    }

    @Bean(value={"europeanaClientDetailsService"})
    public EuropeanaClientDetailsService getClientDetailsService() {
        EuropeanaClientDetailsService clientDetailsService = new EuropeanaClientDetailsService();
        clientDetailsService.setApiKeyServiceUrl(this.translationConfig.getApiKeyUrl());
        return clientDetailsService;
    }

    @Bean(value={"i18nService"})
    public I18nService getI18nService() {
        return new I18nServiceImpl();
    }

    @Bean(value={"messageSource"})
    public MessageSource getMessageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasename("classpath:messages");
        messageSource.setDefaultEncoding("utf-8");
        messageSource.setDefaultLocale(Locale.ENGLISH);
        return messageSource;
    }

    @Bean(value={"translationServiceProvider"})
    @DependsOn(value={"redisCacheMessageListenerContainer"})
    public TranslationServiceProvider getTranslationServiceProvider() {
        this.translationServiceProvider = StringUtils.isNotEmpty((CharSequence)this.serviceConfigFile) ? new TranslationServiceProvider(this.translationConfig.getConfigFile(this.serviceConfigFile)) : new TranslationServiceProvider();
        return this.translationServiceProvider;
    }

    @Bean(value={"langDetectPreProcessorService"})
    public LangDetectionPreProcessor langDetectionPreProcessor() {
        return new LangDetectionPreProcessor(IsAlphabetic);
    }

    @Bean(value={"translationPreProcessorService"})
    public TranslationPreProcessor translationPreProcessor() {
        return new TranslationPreProcessor(IsAlphabetic);
    }

    @Bean(value={"redisConnectionFactory"})
    LettuceConnectionFactory getRedisConnectionFactory() throws AppConfigurationException {
        LettuceClientConfiguration.LettuceClientConfigurationBuilder lettuceClientConfigurationBuilder = LettuceClientConfiguration.builder();
        boolean sslEnabled = this.translationConfig.getRedisConnectionUrl().startsWith("rediss");
        if (sslEnabled) {
            File truststore = this.getTrustoreFile();
            SslOptions sslOptions = SslOptions.builder().jdkSslProvider().truststore(truststore, this.translationConfig.getTruststorePass()).build();
            ClientOptions clientOptions = ClientOptions.builder().sslOptions(sslOptions).build();
            lettuceClientConfigurationBuilder.clientOptions(clientOptions).useSsl();
        }
        LettuceClientConfiguration lettuceClientConfiguration = lettuceClientConfigurationBuilder.build();
        RedisConfiguration redisConf = LettuceConnectionFactory.createRedisConfiguration((String)this.translationConfig.getRedisConnectionUrl());
        return new LettuceConnectionFactory(redisConf, lettuceClientConfiguration);
    }

    private File getTrustoreFile() throws AppConfigurationException {
        String truststorePathConfig = this.translationConfig.getTruststorePath();
        if (truststorePathConfig == null) {
            throw new AppConfigurationException("A trustore must be provided in configurations when confinguring redis ssl connection");
        }
        File trustoreFile = this.translationConfig.getConfigFile(truststorePathConfig);
        if (!trustoreFile.exists()) {
            throw new AppConfigurationException("Invalid config file location: " + trustoreFile.getAbsolutePath());
        }
        return trustoreFile;
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, CachedTranslation> getRedisTemplate(@Qualifier(value="redisConnectionFactory") LettuceConnectionFactory redisConnectionFactory) throws AppConfigurationException {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisConnectionFactory.afterPropertiesSet();
        redisTemplate.setConnectionFactory((RedisConnectionFactory)redisConnectionFactory);
        redisTemplate.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        redisTemplate.setValueSerializer((RedisSerializer)new Jackson2JsonRedisSerializer(CachedTranslation.class));
        redisTemplate.afterPropertiesSet();
        return redisTemplate;
    }

    @Bean(value={"redisCacheService"})
    @ConditionalOnProperty(name={"redis.connection.url"})
    public RedisCacheService getRedisCacheService(@Qualifier(value="redisTemplate") RedisTemplate<String, CachedTranslation> redisTemplate) throws AppConfigurationException {
        return new RedisCacheService(redisTemplate);
    }

    @Bean(value={"redisMessageListenerAdapter"})
    MessageListenerAdapter listenerAdapter() {
        return new MessageListenerAdapter();
    }

    @Bean(value={"redisCacheMessageListenerContainer"})
    RedisMessageListenerContainer getRedisMessageListenerContainer(@Qualifier(value="redisConnectionFactory") LettuceConnectionFactory redisConnectionFactory, @Qualifier(value="redisMessageListenerAdapter") MessageListenerAdapter messageListenerAdapter) throws AppConfigurationException {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        redisConnectionFactory.afterPropertiesSet();
        container.setConnectionFactory((RedisConnectionFactory)redisConnectionFactory);
        container.addMessageListener((MessageListener)messageListenerAdapter, (Topic)ChannelTopic.of((String)"default"));
        return container;
    }

    public void onApplicationEvent(ApplicationStartedEvent event) {
        if (this.logger.isDebugEnabled()) {
            this.printRegisteredBeans((ApplicationContext)event.getApplicationContext());
        }
        this.loadServices(event);
    }

    private void loadServices(ApplicationStartedEvent event) {
        try {
            this.verifyMandatoryProperties((ApplicationContext)event.getApplicationContext());
            this.initTranslationServices((ApplicationContext)event.getApplicationContext());
        }
        catch (Exception e) {
            this.logger.fatal("Stopping application. Translation Service initialization failed due to configuration errors!", (Throwable)e);
            System.exit(SpringApplication.exit((ApplicationContext)event.getApplicationContext(), (ExitCodeGenerator[])new ExitCodeGenerator[]{() -> 1}));
        }
    }

    public void initTranslationServices(ApplicationContext ctx) throws TranslationServiceConfigurationException, LangDetectionServiceConfigurationException {
        this.translationServiceProvider.initTranslationServicesFromConfiguration();
    }

    public void verifyMandatoryProperties(ApplicationContext ctx) {
        this.translationConfig.verifyRequiredProperties();
    }

    private void printRegisteredBeans(ApplicationContext ctx) {
        Object[] beanNames = ctx.getBeanDefinitionNames();
        Arrays.sort(beanNames);
        this.logger.debug("Instantiated beans:");
        this.logger.debug(StringUtils.join((Object[])beanNames, (String)"\n"));
    }
}

