/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

@Configuration
public class SerializationConfig {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX");

    @Primary
    @Bean(value={"translationJsonMapper"})
    public ObjectMapper mapper() {
        ObjectMapper mapper = new Jackson2ObjectMapperBuilder().defaultUseWrapper(false).dateFormat(this.dateFormat).featuresToEnable(new Object[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).serializationInclusion(JsonInclude.Include.NON_NULL).build();
        mapper.findAndRegisterModules();
        return mapper;
    }
}

