/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.commons.definitions.utils.LoggingUtils;
import eu.europeana.api.translation.config.TranslationConfig;
import eu.europeana.api.translation.config.services.DetectCfg;
import eu.europeana.api.translation.config.services.DetectServiceCfg;
import eu.europeana.api.translation.config.services.TranslationServiceCfg;
import eu.europeana.api.translation.service.LanguageDetectionService;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.exception.LangDetectionServiceConfigurationException;
import eu.europeana.api.translation.service.exception.TranslationServiceConfigurationException;
import eu.europeana.api.translation.service.google.GoogleLangDetectService;
import eu.europeana.api.translation.service.google.GoogleTranslationServiceClientWrapper;
import eu.europeana.api.translation.service.pangeanic.PangeanicLangDetectService;
import eu.europeana.api.translation.service.threshold.ThresholdsConfiguration;
import eu.europeana.api.translation.service.tika.ApacheTikaLangDetectService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Locale;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractServiceInstantiationUtils {
    private static final Logger LOG = LogManager.getLogger(AbstractServiceInstantiationUtils.class);
    public static final char SLASH = '/';

    abstract TranslationConfig getTranslationConfig();

    abstract GoogleTranslationServiceClientWrapper getGoogleTranslationServiceClientWrapper() throws IOException;

    public static GoogleTranslationServiceClientWrapper createGoogleTranslationClientWrapperInstance(TranslationConfig translationConfig) throws IOException {
        return new GoogleTranslationServiceClientWrapper(translationConfig.getGoogleTranslateProjectId(), translationConfig.useGoogleHttpClient());
    }

    public static GoogleLangDetectService createGoogleDetectServiceInstance(TranslationConfig translationConfig, GoogleTranslationServiceClientWrapper googleTranslationServiceClientWrapper) throws IOException {
        GoogleTranslationServiceClientWrapper clientWrapper = googleTranslationServiceClientWrapper == null ? AbstractServiceInstantiationUtils.createGoogleTranslationClientWrapperInstance((TranslationConfig)translationConfig) : googleTranslationServiceClientWrapper;
        return new GoogleLangDetectService(translationConfig.getGoogleTranslateProjectId(), clientWrapper);
    }

    LanguageDetectionService createServiceInstance(DetectServiceCfg serviceCfg, DetectCfg detectCfg) throws LangDetectionServiceConfigurationException {
        Object service;
        try {
            Class<?> clazz = Class.forName(serviceCfg.getClassname());
            service = GoogleLangDetectService.class.equals(clazz) ? AbstractServiceInstantiationUtils.createGoogleDetectServiceInstance((TranslationConfig)this.getTranslationConfig(), (GoogleTranslationServiceClientWrapper)this.getGoogleTranslationServiceClientWrapper()) : (PangeanicLangDetectService.class.equals(clazz) ? new PangeanicLangDetectService(this.getTranslationConfig().getPangeanicDetectEndpoint()) : (LanguageDetectionService)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            if (StringUtils.isNotEmpty((CharSequence)serviceCfg.getId())) {
                service.setServiceId(serviceCfg.getId());
            } else {
                service.setServiceId(clazz.getSimpleName().toUpperCase(Locale.ENGLISH));
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceCfg.getConfigFilePath())) {
                service.setThresholdsConf(this.loadLanguageDetectionThresholds(serviceCfg));
            }
            if (detectCfg.getSupported() != null && service instanceof ApacheTikaLangDetectService) {
                ApacheTikaLangDetectService tikaService = (ApacheTikaLangDetectService)service;
                tikaService.initDetectorPriors(detectCfg.getSupported());
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new LangDetectionServiceConfigurationException("Cannot instantiate service for class: " + serviceCfg.getClassname(), (Throwable)e);
        }
        return service;
    }

    TranslationService createServiceInstance(TranslationServiceCfg serviceCfg) throws TranslationServiceConfigurationException {
        TranslationService service;
        try {
            Class<?> clazz = Class.forName(serviceCfg.getClassname());
            service = (TranslationService)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (StringUtils.isNotEmpty((CharSequence)serviceCfg.getId())) {
                service.setServiceId(serviceCfg.getId());
            } else {
                service.setServiceId(clazz.getSimpleName().toUpperCase(Locale.ENGLISH));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new TranslationServiceConfigurationException("Cannot instantiate service for class: " + serviceCfg.getClassname(), (Throwable)e);
        }
        return service;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ThresholdsConfiguration loadLanguageDetectionThresholds(DetectServiceCfg detectServiceCfg) throws LangDetectionServiceConfigurationException {
        InputStream inputStream;
        String configFileName = detectServiceCfg.getConfigFilePath();
        if (StringUtils.isEmpty((CharSequence)configFileName)) {
            return null;
        }
        File languageThresholdsFile = this.getTranslationConfig().getConfigFile(configFileName);
        if (languageThresholdsFile.exists()) {
            try {
                inputStream = new FileInputStream(languageThresholdsFile);
            }
            catch (FileNotFoundException e) {
                throw new LangDetectionServiceConfigurationException("Unexpected error occured when reading configFile: " + configFileName, (Throwable)e);
            }
        } else {
            Object location = configFileName.startsWith("/") ? configFileName : "/" + configFileName;
            inputStream = AbstractServiceInstantiationUtils.class.getResourceAsStream((String)location);
        }
        if (inputStream == null) {
            throw new LangDetectionServiceConfigurationException("Thresholds configuration file not found, neither in configs nor in classpath: " + configFileName);
        }
        try (InputStreamReader rawReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            ThresholdsConfiguration thresholdsConfiguration;
            try (BufferedReader reader = new BufferedReader(rawReader);){
                String configsAsJsonString = this.readLinesAsString(reader);
                ThresholdsConfiguration thresholdsConf = (ThresholdsConfiguration)new ObjectMapper().readValue(configsAsJsonString, ThresholdsConfiguration.class);
                thresholdsConf.validateThresholds();
                if (LOG.isInfoEnabled()) {
                    LOG.info("Successfully loaded language detection thresholds from config file {}, Values: {}", (Object)configFileName, (Object)thresholdsConf);
                }
                thresholdsConfiguration = thresholdsConf;
            }
            return thresholdsConfiguration;
        }
        catch (IOException e) {
            throw new LangDetectionServiceConfigurationException("Cannot load language detection thresholds from file: " + String.valueOf(languageThresholdsFile), (Throwable)e);
        }
    }

    private String readLinesAsString(BufferedReader reader) {
        return reader.lines().collect(Collectors.joining(System.lineSeparator()));
    }

    public Properties loadPangeanicTranslationThresholds(String configFileName) throws TranslationServiceConfigurationException {
        Properties thresholds;
        block19: {
            thresholds = new Properties();
            File languageThresholdsFile = this.getTranslationConfig().getConfigFile(configFileName);
            if (languageThresholdsFile.exists()) {
                try (BufferedReader input = Files.newBufferedReader(languageThresholdsFile.toPath());){
                    thresholds.load(input);
                    this.logInfo("Successfully loaded pangeanic thresholds from config file, Values: {}", new Object[]{LoggingUtils.sanitizeUserInput((String)thresholds.toString())});
                    break block19;
                }
                catch (IOException e) {
                    throw new TranslationServiceConfigurationException("Cannot load pangeanic language thresholds from config file: " + String.valueOf(languageThresholdsFile), (Throwable)e);
                }
            }
            try (InputStream input = AbstractServiceInstantiationUtils.class.getResourceAsStream("/" + configFileName);){
                if (input != null) {
                    thresholds.load(input);
                    this.logInfo("Successfully loaded pangeanic thresholds from resources, Values: {}", new Object[]{LoggingUtils.sanitizeUserInput((String)thresholds.toString())});
                }
            }
            catch (IOException e) {
                throw new TranslationServiceConfigurationException("Cannot load pangeanic languae thresholds from file: " + String.valueOf(languageThresholdsFile), (Throwable)e);
            }
        }
        if (thresholds.isEmpty()) {
            this.logInfo("No configurations found for pangeanic language thresholds available.", new Object[0]);
        }
        return thresholds;
    }

    private void logInfo(String message, Object ... params) {
        if (LOG.isInfoEnabled()) {
            LOG.info(message, params);
        }
    }
}

