/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.client.service;

import eu.europeana.api.translation.client.exception.TranslationApiException;
import eu.europeana.api.translation.client.utils.TranslationClientUtils;
import eu.europeana.api.translation.definitions.language.LanguagePair;
import eu.europeana.api.translation.definitions.model.LangDetectResponse;
import eu.europeana.api.translation.definitions.model.TranslationResponse;
import java.net.URI;
import java.util.Set;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.web.util.UriBuilder;

public class TranslationApiRestClient {
    private static final Logger LOGGER = LogManager.getLogger(TranslationApiRestClient.class);
    private static final String ERROR_MESSAGE = "Translation API Client call failed - ";
    private final WebClient webClient;

    public TranslationApiRestClient(WebClient apiClient) {
        this.webClient = apiClient;
    }

    public TranslationResponse getTranslations(String request, String authToken) throws TranslationApiException {
        return (TranslationResponse)this.getTranslationApiResponse(this.webClient, TranslationClientUtils.buildUrl("translate"), request, false, authToken);
    }

    public LangDetectResponse getDetectedLanguages(String request, String authToken) throws TranslationApiException {
        return (LangDetectResponse)this.getTranslationApiResponse(this.webClient, TranslationClientUtils.buildUrl("detect"), request, true, authToken);
    }

    public void getSupportedLanguages(Set<String> supportedLanguagesForDetection, Set<LanguagePair> supportedLanguagesForTranslation) throws TranslationApiException {
        String json = this.getInfoEndpointResponse();
        TranslationClientUtils.getDetectionLanguages(json, supportedLanguagesForDetection);
        TranslationClientUtils.getTranslationLanguagePairs(json, supportedLanguagesForTranslation);
    }

    private String getInfoEndpointResponse() throws TranslationApiException {
        try {
            WebClient.ResponseSpec result = this.executeGet(this.webClient, TranslationClientUtils.buildUrl("actuator/info"), null);
            return (String)result.bodyToMono(String.class).block();
        }
        catch (WebClientResponseException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Translation API Client call failed -  {} ", (Object)e.getMessage());
            }
            throw new TranslationApiException(ERROR_MESSAGE + e.getMessage(), e.getRawStatusCode(), e);
        }
    }

    public <T> T getTranslationApiResponse(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, String jsonBody, boolean langDetect, String authToken) throws TranslationApiException {
        try {
            WebClient.ResponseSpec result = this.executePost(webClient, uriBuilderURIFunction, jsonBody, authToken);
            if (langDetect) {
                return (T)result.bodyToMono(LangDetectResponse.class).block();
            }
            return (T)result.bodyToMono(TranslationResponse.class).block();
        }
        catch (WebClientResponseException e) {
            String message = this.getErrorMessage(e.getResponseBodyAsString(), e.getMessage());
            LOGGER.debug("Translation API Client call failed -  {} ", (Object)message);
            throw new TranslationApiException(ERROR_MESSAGE + message, e.getRawStatusCode(), e);
        }
    }

    private WebClient.ResponseSpec executePost(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, String jsonBody, String authToken) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)webClient.post().uri(uriBuilderURIFunction)).contentType(MediaType.APPLICATION_JSON).header("Authorization", new String[]{authToken})).body(BodyInserters.fromValue((Object)jsonBody)).retrieve();
    }

    private WebClient.ResponseSpec executeGet(WebClient webClient, Function<UriBuilder, URI> uriBuilderURIFunction, String authToken) {
        return webClient.get().uri(uriBuilderURIFunction).accept(new MediaType[]{MediaType.APPLICATION_JSON}).header("Authorization", new String[]{authToken}).retrieve();
    }

    private String getErrorMessage(String errorResponse, String defaultMessage) {
        if (StringUtils.isNotEmpty((CharSequence)errorResponse) && errorResponse.contains("message")) {
            return StringUtils.substringBetween((String)errorResponse, (String)"\"message\":", (String)"\",");
        }
        return defaultMessage;
    }
}

