/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TranslationClientConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(TranslationClientConfiguration.class);
    public static final String PROPERTIES_FILE = "/translation-api-client.properties";
    public static final String TRANSLATION_API_URL = "translation.api.endpoint";
    Properties properties;

    public TranslationClientConfiguration() {
        this.loadProperties(PROPERTIES_FILE);
    }

    public TranslationClientConfiguration(Properties properties) {
        this.properties = properties;
    }

    private Properties loadProperties(String propertiesFile) {
        this.properties = new Properties();
        try (InputStream stream = this.getClass().getResourceAsStream(propertiesFile);){
            this.properties.load(stream);
        }
        catch (IOException e) {
            LOGGER.error("Error loading the properties file {}", (Object)PROPERTIES_FILE);
        }
        return this.properties;
    }

    public String getTranslationApiUrl() {
        return this.getProperty(TRANSLATION_API_URL);
    }

    private String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }
}

