/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.translation.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import eu.europeana.api.translation.client.BaseTranslationApiClient;
import eu.europeana.api.translation.client.config.TranslationClientConfiguration;
import eu.europeana.api.translation.client.exception.TranslationApiException;
import eu.europeana.api.translation.client.utils.TranslationClientUtils;
import eu.europeana.api.translation.definitions.language.LanguagePair;
import eu.europeana.api.translation.definitions.model.LangDetectRequest;
import eu.europeana.api.translation.definitions.model.LangDetectResponse;
import eu.europeana.api.translation.definitions.model.LanguageDetectionObj;
import eu.europeana.api.translation.definitions.model.TranslationObj;
import eu.europeana.api.translation.definitions.model.TranslationRequest;
import eu.europeana.api.translation.definitions.model.TranslationResponse;
import eu.europeana.api.translation.service.AbstractLanguageDetectionService;
import eu.europeana.api.translation.service.LanguageDetectionService;
import eu.europeana.api.translation.service.TranslationService;
import eu.europeana.api.translation.service.exception.LanguageDetectionException;
import eu.europeana.api.translation.service.exception.TranslationException;
import java.util.List;

public class TranslationApiClient
extends BaseTranslationApiClient {
    private static final String SERVICE_ID = "TRANSLATION_CLIENT";
    private static final String TOKEN_ERROR_MESSAGE = "Translation API client has not been initialized with a token or has been closed!";
    public static final ThreadLocal<String> token = new ThreadLocal();
    private final TranslationClient translationClient = new TranslationClient();
    private final LanguageDetectionClient languageDetectionClient = new LanguageDetectionClient();

    public TranslationApiClient(TranslationClientConfiguration configuration) throws TranslationApiException {
        super(configuration);
    }

    public TranslationService getTranslationService() {
        return this.translationClient;
    }

    public LanguageDetectionService getLanguageDetectionService() {
        return this.languageDetectionClient;
    }

    public void setAuthToken(String authToken) {
        token.set(authToken);
    }

    public void close() {
        token.remove();
    }

    private <T> String getJsonString(T request) throws TranslationApiException {
        try {
            return this.getObjectWriter().writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new TranslationApiException("Error parsing the request for Translation API");
        }
    }

    private class TranslationClient
    implements TranslationService {
        private TranslationClient() {
        }

        public String getServiceId() {
            return TranslationApiClient.SERVICE_ID;
        }

        public void setServiceId(String serviceId) {
        }

        public boolean isSupported(String srcLang, String trgLang) {
            return TranslationApiClient.this.getSupportedLanguagesForTranslation().contains(new LanguagePair(srcLang, trgLang));
        }

        public void translate(List<TranslationObj> translationStrings) throws TranslationException {
            if (translationStrings.isEmpty()) {
                return;
            }
            String authToken = token.get();
            if (authToken == null) {
                throw new TranslationException(TranslationApiClient.TOKEN_ERROR_MESSAGE);
            }
            TranslationRequest translationRequest = TranslationClientUtils.createTranslationRequest(translationStrings);
            try {
                TranslationResponse response = TranslationApiClient.this.getTranslationApiRestClient().getTranslations(TranslationApiClient.this.getJsonString(translationRequest), authToken);
                List translations = response.getTranslations();
                for (int i = 0; i < translations.size(); ++i) {
                    translationStrings.get(i).setTranslation((String)translations.get(i));
                }
            }
            catch (TranslationApiException e) {
                if (BaseTranslationApiClient.LOG.isDebugEnabled()) {
                    BaseTranslationApiClient.LOG.debug(e.getMessage());
                }
                throw new TranslationException(e.getMessage(), e.getRemoteStatusCode(), (Throwable)e);
            }
        }

        public void close() {
            TranslationApiClient.this.close();
        }

        public String getExternalServiceEndPoint() {
            return null;
        }
    }

    private class LanguageDetectionClient
    extends AbstractLanguageDetectionService {
        private LanguageDetectionClient() {
        }

        public boolean isSupported(String srcLang) {
            return TranslationApiClient.this.getSupportedLanguagesForDetection().contains(srcLang);
        }

        public String getServiceId() {
            return TranslationApiClient.SERVICE_ID;
        }

        public void detectLang(List<LanguageDetectionObj> languageDetectionObjs) throws LanguageDetectionException {
            if (languageDetectionObjs.isEmpty()) {
                return;
            }
            String authToken = token.get();
            if (authToken == null) {
                throw new LanguageDetectionException(TranslationApiClient.TOKEN_ERROR_MESSAGE);
            }
            LangDetectRequest langDetectRequest = TranslationClientUtils.createLangDetectRequest(languageDetectionObjs);
            try {
                LangDetectResponse response = TranslationApiClient.this.getTranslationApiRestClient().getDetectedLanguages(TranslationApiClient.this.getJsonString(langDetectRequest), authToken);
                List detectedLang = response.getLangs();
                for (int i = 0; i < detectedLang.size(); ++i) {
                    languageDetectionObjs.get(i).setDetectedLang((String)detectedLang.get(i));
                }
            }
            catch (TranslationApiException e) {
                if (BaseTranslationApiClient.LOG.isDebugEnabled()) {
                    BaseTranslationApiClient.LOG.debug(e.getMessage());
                }
                throw new LanguageDetectionException(e.getMessage(), e.getRemoteStatusCode(), (Throwable)e);
            }
        }

        public void close() {
            TranslationApiClient.this.close();
        }
    }
}

