/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.entity;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Indexed;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.BatchRepositoryUtils;
import java.util.HashMap;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;

@Entity(value="JobInstance")
public class JobInstanceEntity {
    @Id
    private ObjectId _id;
    private String jobName;
    private long jobInstanceId;
    private int version;
    @Indexed
    private String jobKey;
    private Map<String, Object> jobParameters = new HashMap<String, Object>();

    public String getJobName() {
        return this.jobName;
    }

    public long getJobInstanceId() {
        return this.jobInstanceId;
    }

    public int getVersion() {
        return this.version;
    }

    public String getJobKey() {
        return this.jobKey;
    }

    public Map<String, Object> getJobParameters() {
        return this.jobParameters;
    }

    public static JobInstanceEntity toEntity(JobInstance jobInstance, JobParameters jobParameters) {
        Map<String, Object> paramMap = BatchRepositoryUtils.convertToMap(jobParameters);
        JobInstanceEntity jobInstanceEntity = new JobInstanceEntity();
        jobInstanceEntity.jobInstanceId = jobInstance.getInstanceId();
        jobInstanceEntity.jobName = jobInstance.getJobName();
        jobInstanceEntity.jobKey = BatchConstants.JOB_KEY_GENERATOR.generateKey((Object)jobParameters);
        jobInstanceEntity.version = jobInstance.getVersion();
        jobInstanceEntity.jobParameters = paramMap;
        return jobInstanceEntity;
    }

    public static JobInstance fromEntity(JobInstanceEntity jobInstanceEntity) {
        if (jobInstanceEntity == null) {
            return null;
        }
        JobInstance jobInstance = new JobInstance(Long.valueOf(jobInstanceEntity.getJobInstanceId()), jobInstanceEntity.getJobName());
        jobInstance.incrementVersion();
        return jobInstance;
    }
}

