/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.repository;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Sort;
import dev.morphia.query.filters.Filter;
import dev.morphia.query.filters.Filters;
import dev.morphia.query.updates.UpdateOperator;
import dev.morphia.query.updates.UpdateOperators;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.entity.JobExecutionEntity;
import eu.europeana.batch.repository.AbstractRepository;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.NoSuchObjectException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

@Repository
public class JobExecutionRepository
extends AbstractRepository
implements JobExecutionDao {
    public JobExecutionRepository(Datastore datastore) {
        super(datastore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        jobExecution.incrementVersion();
        JobExecutionRepository jobExecutionRepository = this;
        synchronized (jobExecutionRepository) {
            jobExecution.setId(Long.valueOf(this.generateSequence(JobExecutionEntity.class.getSimpleName())));
        }
        JobExecutionEntity jobExecutionEntity = JobExecutionEntity.toEntity(jobExecution);
        this.getDataStore().save((Object)jobExecutionEntity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJobExecution(JobExecution jobExecution) {
        this.validateJobExecution(jobExecution);
        Long jobExecutionId = jobExecution.getId();
        Assert.notNull((Object)jobExecutionId, (String)"JobExecution ID cannot be null. JobExecution must be saved before it can be updated");
        Assert.notNull((Object)jobExecution.getVersion(), (String)"JobExecution version cannot be null. JobExecution must be saved before it can be updated");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            int nextVersion = jobExecution.getVersion() + 1;
            if (this.getJobExecutionWithId(jobExecutionId) == null) {
                throw new NoSuchObjectException("Invalid JobExecution, ID " + jobExecution.getId() + " not found.");
            }
            UpdateResult result = this.queryUpdateJobExecution(jobExecution, jobExecutionId, nextVersion);
            if (result.getModifiedCount() == 0L) {
                int currentVersion = this.queryGetJobExecutionVersion(jobExecutionId);
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + jobExecution.getId() + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + currentVersion);
            }
        }
    }

    public List<JobExecution> findJobExecutions(JobInstance job) {
        Assert.notNull((Object)job, (String)"Job cannot be null.");
        Assert.notNull((Object)job.getId(), (String)"Job Id cannot be null.");
        return this.queryGetJobExecutions(job.getId()).stream().map(JobExecutionEntity::fromEntity).collect(Collectors.toList());
    }

    @Nullable
    public JobExecution getLastJobExecution(JobInstance jobInstance) {
        long id = jobInstance.getId();
        JobExecutionEntity executionEntity = this.queryGetLastJobExecutionForInstance(id);
        if (executionEntity == null) {
            return null;
        }
        return JobExecutionEntity.fromEntity(executionEntity);
    }

    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        List<Long> ids = this.getJobInstanceIdsWithName(jobName);
        List<JobExecutionEntity> jobExecutions = this.queryGetRunningJobExecutions(ids);
        return jobExecutions.stream().map(JobExecutionEntity::fromEntity).collect(Collectors.toSet());
    }

    @Nullable
    public JobExecution getJobExecution(Long jobExecutionId) {
        return JobExecutionEntity.fromEntity(this.getJobExecutionWithId(jobExecutionId));
    }

    public void synchronizeStatus(JobExecution jobExecution) {
        int currentVersion = this.queryGetJobExecutionVersion(jobExecution.getId());
        if (currentVersion != jobExecution.getVersion()) {
            String status = this.queryGetJobExecutionStatus(jobExecution.getId());
            jobExecution.upgradeStatus(BatchStatus.valueOf((String)status));
            jobExecution.setVersion(Integer.valueOf(currentVersion));
        }
    }

    private void validateJobExecution(JobExecution jobExecution) {
        Assert.notNull((Object)jobExecution, (String)"JobExecution cannot be null.");
        Assert.notNull((Object)jobExecution.getJobId(), (String)"JobExecution Job-Id cannot be null.");
        Assert.notNull((Object)jobExecution.getStatus(), (String)"JobExecution status cannot be null.");
        Assert.notNull((Object)jobExecution.getCreateTime(), (String)"JobExecution create time cannot be null");
    }

    private int queryGetJobExecutionVersion(long jobExecutionId) {
        return ((JobExecutionEntity)this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).iterator(new FindOptions().projection().include(new String[]{"version"}).limit(1)).next()).getVersion();
    }

    private UpdateResult queryUpdateJobExecution(JobExecution jobExecution, Long jobExecutionId, int nextVersion) {
        return this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId), Filters.eq((String)"version", (Object)jobExecution.getVersion())}).update(UpdateOperators.set((String)"jobExecutionId", (Object)jobExecutionId), new UpdateOperator[]{UpdateOperators.set((String)"version", (Object)nextVersion), UpdateOperators.set((String)"jobInstanceId", (Object)jobExecution.getJobId()), this.handleNullField("startTime", jobExecution.getStartTime()), this.handleNullField("endTime", jobExecution.getEndTime()), UpdateOperators.set((String)"status", (Object)jobExecution.getStatus().toString()), UpdateOperators.set((String)"exitCode", (Object)jobExecution.getExitStatus().getExitCode()), UpdateOperators.set((String)"exitMessage", (Object)jobExecution.getExitStatus().getExitDescription()), this.handleNullField("createTime", jobExecution.getCreateTime()), this.handleNullField("lastUpdated", jobExecution.getLastUpdated())}).execute();
    }

    private String queryGetJobExecutionStatus(long jobExecutionId) {
        return ((JobExecutionEntity)this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).iterator(new FindOptions().projection().include(new String[]{"status"}).limit(1)).next()).getStatus();
    }

    private JobExecutionEntity queryGetLastJobExecutionForInstance(long jobInstanceId) {
        return (JobExecutionEntity)this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobInstanceId", (Object)jobInstanceId)}).iterator(new FindOptions().sort(new Sort[]{Sort.descending((String)"createTime")}).limit(1)).tryNext();
    }

    private List<JobExecutionEntity> queryGetRunningJobExecutions(List<Long> jobInstanceIds) {
        return this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"endTime", null), Filters.in((String)"jobInstanceId", jobInstanceIds)}).iterator(BatchConstants.DESCENDING_JOB_EXECUTION).toList();
    }
}

