/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.repository;

import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Query;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.entity.JobInstanceEntity;
import eu.europeana.batch.repository.AbstractRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobInstanceRepository
extends AbstractRepository
implements JobInstanceDao {
    public JobInstanceRepository(Datastore datastore) {
        super(datastore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        JobInstance jobInstance;
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        Assert.state((this.getJobInstance(jobName, jobParameters) == null ? 1 : 0) != 0, (String)"JobInstance must not already exist");
        JobInstanceRepository jobInstanceRepository = this;
        synchronized (jobInstanceRepository) {
            long jobId = this.generateSequence(JobInstanceEntity.class.getSimpleName());
            jobInstance = new JobInstance(Long.valueOf(jobId), jobName);
        }
        jobInstance.incrementVersion();
        JobInstanceEntity jobInstanceEntity = JobInstanceEntity.toEntity(jobInstance, jobParameters);
        this.getDataStore().save((Object)jobInstanceEntity);
        return jobInstance;
    }

    @Nullable
    public JobInstance getJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        String jobKey = BatchConstants.JOB_KEY_GENERATOR.generateKey((Object)jobParameters);
        List<JobInstanceEntity> instances = this.queryGetJobInstances(jobName, jobKey);
        Assert.state((instances.size() <= 1 ? 1 : 0) != 0, (String)("JobInstances cannot be more than 1. Was " + instances.size()));
        if (instances.isEmpty()) {
            return null;
        }
        return JobInstanceEntity.fromEntity(instances.get(0));
    }

    @Nullable
    public JobInstance getJobInstance(Long instanceId) {
        return JobInstanceEntity.fromEntity(this.queryGetJobInstance(instanceId));
    }

    public JobInstance getJobInstance(JobExecution jobExecution) {
        long instanceId = this.getJobExecutionInstanceId(jobExecution.getId());
        return this.getJobInstance(instanceId);
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        return this.queryGetJobInstances(Filters.eq((String)"jobName", (Object)jobName), start, count).stream().map(JobInstanceEntity::fromEntity).collect(Collectors.toList());
    }

    public List<String> getJobNames() {
        return this.queryDistinctJobNames();
    }

    public List<JobInstance> findJobInstancesByName(String jobName, int start, int count) {
        return this.queryGetJobInstances((Filter)Filters.regex((String)"jobName").pattern(".*" + jobName + ".*"), start, count).stream().map(JobInstanceEntity::fromEntity).collect(Collectors.toList());
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        long count = this.queryCountJobInstances(jobName);
        if (count == 0L) {
            throw new NoSuchJobException("No job instances were found for job name " + jobName);
        }
        return (int)count;
    }

    private JobInstanceEntity queryGetJobInstance(long jobInstanceId) {
        return (JobInstanceEntity)this.getDataStore().find(JobInstanceEntity.class).filter(new Filter[]{Filters.eq((String)"jobInstanceId", (Object)jobInstanceId)}).first();
    }

    private List<JobInstanceEntity> queryGetJobInstances(Filter jobNameFilter, int start, int count) {
        return this.getDataStore().find(JobInstanceEntity.class).filter(new Filter[]{jobNameFilter}).iterator(new FindOptions().sort(new Sort[]{Sort.descending((String)"jobInstanceId")}).skip(start).limit(count)).toList();
    }

    private List<JobInstanceEntity> queryGetJobInstances(String jobName, String jobKey) {
        Query query = this.getDataStore().find(JobInstanceEntity.class);
        if (StringUtils.hasLength((String)jobKey)) {
            query.filter(new Filter[]{Filters.eq((String)"jobKey", (Object)jobKey)});
        } else {
            query.filter(new Filter[]{Filters.or((Filter[])new Filter[]{Filters.eq((String)"jobKey", (Object)jobKey), Filters.eq((String)"jobKey", null)})});
        }
        return query.filter(new Filter[]{Filters.eq((String)"jobName", (Object)jobName)}).iterator().toList();
    }

    @Nullable
    public JobInstance getLastJobInstance(@NonNull String jobName) {
        List<JobInstanceEntity> instances = this.queryGetJobInstances(Filters.eq((String)"jobName", (Object)jobName), 0, 1);
        if (instances == null || instances.isEmpty()) {
            return null;
        }
        return JobInstanceEntity.fromEntity(instances.get(0));
    }

    private List<String> queryDistinctJobNames() {
        return this.queryDistinctStringValues(JobInstanceEntity.class, "jobName");
    }

    private long queryCountJobInstances(String jobName) {
        return this.getDataStore().find(JobInstanceEntity.class).filter(new Filter[]{Filters.eq((String)"jobName", (Object)jobName)}).count();
    }
}

