/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.repository;

import dev.morphia.Datastore;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.entity.ExecutionContextEntity;
import eu.europeana.batch.entity.ExecutionContextEntityType;
import eu.europeana.batch.repository.AbstractRepository;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.Jackson2ExecutionContextStringSerializer;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class ExecutionContextRepository
extends AbstractRepository
implements ExecutionContextDao {
    private final ExecutionContextSerializer serializer = new Jackson2ExecutionContextStringSerializer(new String[0]);

    public ExecutionContextRepository(Datastore datastore) {
        super(datastore);
    }

    public ExecutionContext getExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        ExecutionContextEntity ctxEntity = this.queryFindExecutionContext(ExecutionContextEntityType.JOB, executionId);
        return ExecutionContextEntity.fromEntity(ctxEntity, this.serializer);
    }

    public ExecutionContext getExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        ExecutionContextEntity ctxEntity = this.queryFindExecutionContext(ExecutionContextEntityType.STEP, executionId);
        return ExecutionContextEntity.fromEntity(ctxEntity, this.serializer);
    }

    public void saveExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        this.querySaveExecutionContext(ExecutionContextEntityType.JOB, executionId, executionContext);
    }

    public void saveExecutionContext(StepExecution stepExecution) {
        Long executionId = stepExecution.getId();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        this.querySaveExecutionContext(ExecutionContextEntityType.STEP, executionId, executionContext);
    }

    public void saveExecutionContexts(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save an null collection of step executions");
        ArrayList<ExecutionContextEntity> ctxEntities = new ArrayList<ExecutionContextEntity>(stepExecutions.size());
        for (StepExecution stepExecution : stepExecutions) {
            Long executionId = stepExecution.getId();
            ExecutionContext executionContext = stepExecution.getExecutionContext();
            Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
            Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
            ctxEntities.add(new ExecutionContextEntity(ExecutionContextEntityType.STEP, executionId, this.serializeContext(executionContext)));
        }
        this.getDataStore().save(ctxEntities, BatchConstants.BATCH_INSERT_OPTIONS);
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        Long executionId = jobExecution.getId();
        ExecutionContext executionContext = jobExecution.getExecutionContext();
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.queryUpdateExecutionContext(ExecutionContextEntityType.JOB, executionId, serializedContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExecutionContext(StepExecution stepExecution) {
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            Long executionId = stepExecution.getId();
            ExecutionContext executionContext = stepExecution.getExecutionContext();
            Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
            Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
            String serializedContext = this.serializeContext(executionContext);
            this.queryUpdateExecutionContext(ExecutionContextEntityType.STEP, executionId, serializedContext);
        }
    }

    private void queryUpdateExecutionContext(ExecutionContextEntityType type, Long executionId, String serializedContext) {
        this.getDataStore().find(ExecutionContextEntity.class).filter(new Filter[]{Filters.eq((String)"executionId", (Object)executionId), Filters.eq((String)"type", (Object)type.toString())}).update(UpdateOperators.set((String)"serializedContext", (Object)serializedContext), new UpdateOperator[0]).execute();
    }

    private ExecutionContextEntity queryFindExecutionContext(ExecutionContextEntityType type, long executionId) {
        return (ExecutionContextEntity)this.getDataStore().find(ExecutionContextEntity.class).filter(new Filter[]{Filters.eq((String)"type", (Object)type.toString()), Filters.eq((String)"executionId", (Object)executionId)}).first();
    }

    private void querySaveExecutionContext(ExecutionContextEntityType type, Long executionId, ExecutionContext executionContext) {
        Assert.notNull((Object)executionId, (String)"ExecutionId must not be null.");
        Assert.notNull((Object)executionContext, (String)"The ExecutionContext must not be null.");
        String serializedContext = this.serializeContext(executionContext);
        this.getDataStore().save((Object)ExecutionContextEntity.toEntity(type, executionId, serializedContext));
    }

    private String serializeContext(ExecutionContext ctx) {
        String results;
        HashMap m = new HashMap();
        for (Map.Entry me : ctx.entrySet()) {
            m.put((String)me.getKey(), me.getValue());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.serializer.serialize(m, (OutputStream)out);
            results = out.toString(StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Could not serialize the execution context", ioe);
        }
        return results;
    }
}

