/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.entity;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexes;
import eu.europeana.batch.entity.ExecutionContextEntityType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.bson.types.ObjectId;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.item.ExecutionContext;

@Entity(value="ExecutionContext")
@Indexes(value={@Index(fields={@Field(value="executionId"), @Field(value="type")})})
public class ExecutionContextEntity {
    @Id
    private ObjectId _id;
    private long executionId;
    private String serializedContext;
    private ExecutionContextEntityType type;

    public long getExecutionId() {
        return this.executionId;
    }

    public String getSerializedContext() {
        return this.serializedContext;
    }

    public ExecutionContextEntityType getType() {
        return this.type;
    }

    public ExecutionContextEntity() {
    }

    public ExecutionContextEntity(ExecutionContextEntityType type, long executionId, String serializedContext) {
        this.type = type;
        this.executionId = executionId;
        this.serializedContext = serializedContext;
    }

    public static ExecutionContextEntity toEntity(ExecutionContextEntityType type, Long executionId, String serializedContext) {
        return new ExecutionContextEntity(type, executionId, serializedContext);
    }

    public static ExecutionContext fromEntity(ExecutionContextEntity entity, ExecutionContextSerializer serializer) {
        Map map;
        ExecutionContext executionContext = new ExecutionContext();
        if (entity == null) {
            return executionContext;
        }
        String serializedContext = entity.getSerializedContext();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(serializedContext.getBytes(StandardCharsets.UTF_8));
            map = (Map)serializer.deserialize((InputStream)in);
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Unable to deserialize the execution context", ioe);
        }
        for (Map.Entry entry : map.entrySet()) {
            executionContext.put((String)entry.getKey(), entry.getValue());
        }
        return executionContext;
    }
}

