/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;

public class BatchRepositoryUtils {
    public static Map<String, Object> convertToMap(JobParameters jobParameters) {
        Map jobParams = jobParameters.getParameters();
        HashMap<String, Object> paramMap = new HashMap<String, Object>(jobParams.size());
        for (Map.Entry entry : jobParams.entrySet()) {
            paramMap.put(((String)entry.getKey()).replaceAll("\\.", "\\-"), ((JobParameter)entry.getValue()).getValue());
        }
        return paramMap;
    }

    public static JobParameters convertToJobParameters(Map<String, Object> originParams) {
        if (originParams == null || originParams.isEmpty()) {
            return new JobParameters();
        }
        HashMap<String, JobParameter> destParams = new HashMap<String, JobParameter>();
        for (Map.Entry<String, Object> param : originParams.entrySet()) {
            String key = param.getKey();
            Object value = param.getValue();
            JobParameter jobParameter = null;
            if (value.getClass().isAssignableFrom(String.class)) {
                jobParameter = new JobParameter(String.valueOf(value));
            } else if (value.getClass().isAssignableFrom(Long.class)) {
                jobParameter = new JobParameter((Long)value);
            } else if (value.getClass().isAssignableFrom(Double.class)) {
                jobParameter = new JobParameter((Double)value);
            } else if (value.getClass().isAssignableFrom(Date.class)) {
                jobParameter = new JobParameter((Date)value);
            }
            destParams.put(key, jobParameter);
        }
        return new JobParameters(destParams);
    }
}

