/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.repository;

import com.mongodb.client.result.UpdateResult;
import dev.morphia.Datastore;
import dev.morphia.query.FindOptions;
import dev.morphia.query.Sort;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.entity.JobExecutionEntity;
import eu.europeana.batch.entity.StepExecutionEntity;
import eu.europeana.batch.repository.AbstractRepository;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class StepExecutionRepository
extends AbstractRepository
implements StepExecutionDao {
    public StepExecutionRepository(Datastore datastore) {
        super(datastore);
    }

    public void saveStepExecution(StepExecution stepExecution) {
        this.prepareForSaving(stepExecution);
        StepExecutionEntity stepExecutionEntity = StepExecutionEntity.toEntity(stepExecution);
        this.getDataStore().save((Object)stepExecutionEntity);
    }

    public void saveStepExecutions(Collection<StepExecution> stepExecutions) {
        Assert.notNull(stepExecutions, (String)"Attempt to save an null collect of step executions");
        for (StepExecution stepExecution : stepExecutions) {
            this.prepareForSaving(stepExecution);
        }
        List entities = stepExecutions.stream().map(StepExecutionEntity::toEntity).collect(Collectors.toList());
        this.getDataStore().save(entities, BatchConstants.BATCH_INSERT_OPTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStepExecution(StepExecution stepExecution) {
        this.validateStepExecution(stepExecution);
        Assert.notNull((Object)stepExecution.getId(), (String)"StepExecution Id cannot be null. StepExecution must saved before it can be updated.");
        StepExecution stepExecution2 = stepExecution;
        synchronized (stepExecution2) {
            int nextVersion = stepExecution.getVersion() + 1;
            UpdateResult result = this.queryUpdateStepExecution(stepExecution, nextVersion);
            if (result.getModifiedCount() == 0L) {
                int currentVersion = this.queryGetStepExecutionVersion(stepExecution.getId());
                throw new OptimisticLockingFailureException("Attempt to update step execution id=" + stepExecution.getId() + " with wrong version (" + stepExecution.getVersion() + "), where current version is " + currentVersion);
            }
            stepExecution.incrementVersion();
        }
    }

    @Nullable
    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        long jobInstanceId = jobInstance.getId();
        List<JobExecutionEntity> jobExecutions = this.queryGetJobExecutions(jobInstanceId);
        if (jobExecutions.isEmpty()) {
            return null;
        }
        Map<Long, JobExecutionEntity> jobExecutionMap = jobExecutions.stream().collect(Collectors.toMap(JobExecutionEntity::getJobExecutionId, jobExecutionEntity -> jobExecutionEntity));
        List<StepExecutionEntity> stepExecutions = this.queryGetStepExecutions(jobExecutionMap.keySet(), stepName);
        if (stepExecutions.isEmpty()) {
            return null;
        }
        StepExecutionEntity stepExecution = stepExecutions.get(0);
        JobExecutionEntity jobExecution = jobExecutionMap.get(stepExecution.getJobExecutionId());
        return StepExecutionEntity.fromEntity(stepExecution, JobExecutionEntity.fromEntity(jobExecution));
    }

    public int countStepExecutions(JobInstance jobInstance, String stepName) {
        long jobInstanceId = jobInstance.getId();
        List<Long> jobExecutionId = this.queryGetJobExecutionIds(jobInstanceId);
        if (jobExecutionId.isEmpty()) {
            return 0;
        }
        return (int)this.queryCountStepExecutions(jobExecutionId, stepName);
    }

    @Nullable
    public StepExecution getStepExecution(JobExecution jobExecution, @NonNull Long stepExecutionId) {
        List<StepExecutionEntity> instances = this.queryGetStepExecutions(jobExecution.getId(), stepExecutionId);
        Assert.state((instances.size() <= 1 ? 1 : 0) != 0, (String)"There can be at most one step execution with given name for single job execution");
        return StepExecutionEntity.fromEntity(instances.get(0), jobExecution);
    }

    public void addStepExecutions(JobExecution jobExecution) {
        List<StepExecutionEntity> results = this.queryGetStepExecutionsWithJobExecutionId(jobExecution.getId());
        for (StepExecutionEntity entity : results) {
            StepExecutionEntity.fromEntity(entity, jobExecution);
        }
    }

    private void validateStepExecution(StepExecution stepExecution) {
        Assert.notNull((Object)stepExecution, (String)"StepExecution cannot be null.");
        Assert.notNull((Object)stepExecution.getStepName(), (String)"StepExecution step name cannot be null.");
        Assert.notNull((Object)stepExecution.getStartTime(), (String)"StepExecution start time cannot be null.");
        Assert.notNull((Object)stepExecution.getStatus(), (String)"StepExecution status cannot be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForSaving(StepExecution stepExecution) {
        Assert.isNull((Object)stepExecution.getId(), (String)"to-be-saved (not updated) StepExecution can't already have an id assigned");
        Assert.isNull((Object)stepExecution.getVersion(), (String)"to-be-saved (not updated) StepExecution can't already have a version assigned");
        this.validateStepExecution(stepExecution);
        StepExecutionRepository stepExecutionRepository = this;
        synchronized (stepExecutionRepository) {
            stepExecution.setId(Long.valueOf(this.generateSequence(StepExecutionEntity.class.getSimpleName())));
        }
        stepExecution.incrementVersion();
    }

    private int queryGetStepExecutionVersion(long stepExecutionId) {
        return ((StepExecutionEntity)this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"stepExecutionId", (Object)stepExecutionId)}).iterator(new FindOptions().projection().include(new String[]{"version"}).limit(1)).next()).getVersion();
    }

    private List<StepExecutionEntity> queryGetStepExecutions(long jobExecutionId, long stepExecutionId) {
        return this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"stepExecutionId", (Object)stepExecutionId), Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).iterator().toList();
    }

    private List<StepExecutionEntity> queryGetStepExecutionsWithJobExecutionId(long jobExecutionId) {
        return this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).iterator(new FindOptions().sort(new Sort[]{Sort.ascending((String)"stepExecutionId")})).toList();
    }

    private UpdateResult queryUpdateStepExecution(StepExecution stepExecution, int newVersion) {
        return this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"stepExecutionId", (Object)stepExecution.getId()), Filters.eq((String)"version", (Object)stepExecution.getVersion())}).update(UpdateOperators.set((String)"stepExecutionId", (Object)stepExecution.getId()), new UpdateOperator[]{UpdateOperators.set((String)"stepName", (Object)stepExecution.getStepName()), UpdateOperators.set((String)"jobExecutionId", (Object)stepExecution.getJobExecutionId()), this.handleNullField("startTime", stepExecution.getStartTime()), this.handleNullField("endTime", stepExecution.getEndTime()), this.handleNullField("lastUpdated", stepExecution.getLastUpdated()), UpdateOperators.set((String)"status", (Object)stepExecution.getStatus().toString()), UpdateOperators.set((String)"commitCount", (Object)stepExecution.getCommitCount()), UpdateOperators.set((String)"readCount", (Object)stepExecution.getReadCount()), UpdateOperators.set((String)"filterCount", (Object)stepExecution.getFilterCount()), UpdateOperators.set((String)"writeCount", (Object)stepExecution.getWriteCount()), UpdateOperators.set((String)"exitCode", (Object)stepExecution.getExitStatus().getExitCode()), UpdateOperators.set((String)"exitMessage", (Object)stepExecution.getExitStatus().getExitDescription()), UpdateOperators.set((String)"readSkipCount", (Object)stepExecution.getReadSkipCount()), UpdateOperators.set((String)"writeSkipCount", (Object)stepExecution.getWriteSkipCount()), UpdateOperators.set((String)"processSkipCount", (Object)stepExecution.getProcessSkipCount()), UpdateOperators.set((String)"rollbackCount", (Object)stepExecution.getRollbackCount()), UpdateOperators.set((String)"rollbackCount", (Object)stepExecution.getRollbackCount()), this.handleNullField("version", newVersion)}).execute();
    }

    private List<StepExecutionEntity> queryGetStepExecutions(Iterable<Long> jobExecutionIds, String stepName) {
        return this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"stepName", (Object)stepName), Filters.in((String)"jobExecutionId", jobExecutionIds)}).iterator(new FindOptions().sort(new Sort[]{Sort.descending((String)"startTime"), Sort.descending((String)"stepExecutionId")})).toList();
    }

    private long queryCountStepExecutions(Iterable<Long> jobExecutionIds, String stepName) {
        return this.getDataStore().find(StepExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"stepName", (Object)stepName), Filters.in((String)"jobExecutionId", jobExecutionIds)}).count();
    }
}

