/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.repository;

import com.mongodb.client.DistinctIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.ReturnDocument;
import dev.morphia.Datastore;
import dev.morphia.ModifyOptions;
import dev.morphia.query.FindOptions;
import dev.morphia.query.experimental.filters.Filter;
import dev.morphia.query.experimental.filters.Filters;
import dev.morphia.query.experimental.updates.UpdateOperator;
import dev.morphia.query.experimental.updates.UpdateOperators;
import dev.morphia.query.internal.MorphiaCursor;
import eu.europeana.batch.BatchConstants;
import eu.europeana.batch.entity.JobExecutionEntity;
import eu.europeana.batch.entity.JobInstanceEntity;
import eu.europeana.batch.entity.SequenceGenerator;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractRepository {
    private Datastore datastore;

    public AbstractRepository(Datastore datastore) {
        this.datastore = datastore;
    }

    protected Datastore getDataStore() {
        return this.datastore;
    }

    protected long generateSequence(String internalType) {
        SequenceGenerator nextId = (SequenceGenerator)this.getDataStore().find(SequenceGenerator.class).filter(new Filter[]{Filters.eq((String)"_id", (Object)internalType)}).modify(UpdateOperators.inc((String)"value"), new UpdateOperator[0]).execute(new ModifyOptions().returnDocument(ReturnDocument.AFTER));
        if (nextId == null) {
            nextId = new SequenceGenerator(internalType, 1L);
            this.getDataStore().save((Object)nextId);
        }
        return nextId.getValue();
    }

    protected List<Long> getJobInstanceIdsWithName(String jobName) {
        ArrayList<Long> results = new ArrayList<Long>();
        MorphiaCursor cursor = this.getDataStore().find(JobInstanceEntity.class).filter(new Filter[]{Filters.eq((String)"jobName", (Object)jobName)}).iterator(new FindOptions().projection().include(new String[]{"jobInstanceId"}));
        while (cursor.hasNext()) {
            results.add(((JobInstanceEntity)cursor.next()).getJobInstanceId());
        }
        cursor.close();
        return results;
    }

    protected List<Long> queryGetJobExecutionIds(long jobInstanceId) {
        ArrayList<Long> results = new ArrayList<Long>();
        MorphiaCursor cursor = this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobInstanceId", (Object)jobInstanceId)}).iterator(new FindOptions().projection().include(new String[]{"jobExecutionId"}).limit(1));
        while (cursor.hasNext()) {
            results.add(((JobExecutionEntity)cursor.next()).getJobExecutionId());
        }
        cursor.close();
        return results;
    }

    protected List<JobExecutionEntity> queryGetJobExecutions(long jobInstanceId) {
        return this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobInstanceId", (Object)jobInstanceId)}).iterator(BatchConstants.DESCENDING_JOB_EXECUTION).toList();
    }

    protected JobExecutionEntity getJobExecutionWithId(long jobExecutionId) {
        return (JobExecutionEntity)this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).first();
    }

    protected long getJobExecutionInstanceId(long jobExecutionId) {
        return ((JobExecutionEntity)this.getDataStore().find(JobExecutionEntity.class).filter(new Filter[]{Filters.eq((String)"jobExecutionId", (Object)jobExecutionId)}).iterator(new FindOptions().projection().include(new String[]{"jobInstanceId"}).limit(1)).next()).getJobInstanceId();
    }

    protected List<String> queryDistinctStringValues(Class<?> clazz, String fieldName) {
        DistinctIterable iterable = this.getDataStore().getMapper().getCollection(clazz).distinct(fieldName, String.class);
        MongoCursor cursor = iterable.iterator();
        ArrayList<String> result = new ArrayList<String>();
        while (cursor.hasNext()) {
            result.add((String)cursor.next());
        }
        cursor.close();
        return result;
    }

    protected UpdateOperator handleNullField(String fieldName, Object value) {
        return value == null ? UpdateOperators.unset((String)fieldName) : UpdateOperators.set((String)fieldName, (Object)value);
    }

    protected void dropCollection(Class<?> clazz) {
        this.getDataStore().getMapper().getCollection(clazz).drop();
    }
}

