/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.entity;

import dev.morphia.annotations.Entity;
import dev.morphia.annotations.Field;
import dev.morphia.annotations.Id;
import dev.morphia.annotations.Index;
import dev.morphia.annotations.Indexed;
import dev.morphia.annotations.Indexes;
import java.util.Date;
import org.bson.types.ObjectId;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepExecution;

@Entity(value="StepExecution")
@Indexes(value={@Index(fields={@Field(value="jobExecutionId"), @Field(value="version")})})
public class StepExecutionEntity {
    @Id
    private ObjectId _id;
    @Indexed
    private long stepExecutionId;
    private long jobExecutionId;
    private String stepName;
    private Date startTime;
    private Date endTime;
    private String status;
    private int commitCount;
    private int readCount;
    private int filterCount;
    private int writeCount;
    private String exitCode;
    private String exitMessage;
    private int readSkipCount;
    private int writeSkipCount;
    private int processSkipCount;
    private int rollbackCount;
    private Date lastUpdated;
    private int version;

    public long getStepExecutionId() {
        return this.stepExecutionId;
    }

    public String getStepName() {
        return this.stepName;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public int getFilterCount() {
        return this.filterCount;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getExitMessage() {
        return this.exitMessage;
    }

    public int getReadSkipCount() {
        return this.readSkipCount;
    }

    public int getWriteSkipCount() {
        return this.writeSkipCount;
    }

    public int getProcessSkipCount() {
        return this.processSkipCount;
    }

    public int getRollbackCount() {
        return this.rollbackCount;
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public int getVersion() {
        return this.version;
    }

    public long getJobExecutionId() {
        return this.jobExecutionId;
    }

    public static StepExecutionEntity toEntity(StepExecution stepExecution) {
        StepExecutionEntity entity = new StepExecutionEntity();
        entity.stepExecutionId = stepExecution.getId();
        entity.stepName = stepExecution.getStepName();
        entity.jobExecutionId = stepExecution.getJobExecutionId();
        entity.startTime = stepExecution.getStartTime();
        entity.endTime = stepExecution.getEndTime();
        entity.status = stepExecution.getStatus().toString();
        entity.commitCount = stepExecution.getCommitCount();
        entity.readCount = stepExecution.getReadCount();
        entity.filterCount = stepExecution.getFilterCount();
        entity.writeCount = stepExecution.getWriteCount();
        entity.exitCode = stepExecution.getExitStatus().getExitCode();
        entity.exitMessage = stepExecution.getExitStatus().getExitDescription();
        entity.readSkipCount = stepExecution.getReadSkipCount();
        entity.writeSkipCount = stepExecution.getWriteSkipCount();
        entity.processSkipCount = stepExecution.getProcessSkipCount();
        entity.rollbackCount = stepExecution.getRollbackCount();
        entity.lastUpdated = stepExecution.getLastUpdated();
        entity.version = stepExecution.getVersion();
        return entity;
    }

    public static StepExecution fromEntity(StepExecutionEntity entity, JobExecution jobExecution) {
        if (entity == null) {
            return null;
        }
        StepExecution stepExecution = new StepExecution(entity.getStepName(), jobExecution, Long.valueOf(entity.getStepExecutionId()));
        stepExecution.setStartTime(entity.getStartTime());
        stepExecution.setEndTime(entity.getEndTime());
        stepExecution.setStatus(BatchStatus.valueOf((String)entity.getStatus()));
        stepExecution.setCommitCount(entity.getCommitCount());
        stepExecution.setReadCount(entity.getReadCount());
        stepExecution.setFilterCount(entity.getFilterCount());
        stepExecution.setWriteCount(entity.getWriteCount());
        stepExecution.setExitStatus(new ExitStatus(entity.getExitCode(), entity.getExitMessage()));
        stepExecution.setReadSkipCount(entity.getReadSkipCount());
        stepExecution.setWriteSkipCount(entity.getWriteSkipCount());
        stepExecution.setProcessSkipCount(entity.getProcessSkipCount());
        stepExecution.setRollbackCount(entity.getRollbackCount());
        stepExecution.setLastUpdated(entity.getLastUpdated());
        stepExecution.setVersion(Integer.valueOf(entity.getVersion()));
        return stepExecution;
    }
}

