/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.batch.config;

import dev.morphia.Datastore;
import eu.europeana.batch.repository.ExecutionContextRepository;
import eu.europeana.batch.repository.JobExecutionRepository;
import eu.europeana.batch.repository.JobInstanceRepository;
import eu.europeana.batch.repository.StepExecutionRepository;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.SimpleJobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.batch.core.repository.support.SimpleJobRepository;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

public class MongoBatchConfigurer
implements BatchConfigurer {
    private final ExecutionContextDao mongoExecutionContextDao;
    private final JobExecutionDao mongoJobExecutionDao;
    private final JobInstanceDao mongoJobInstanceDao;
    private final StepExecutionDao mongoStepExecutionDao;
    private final TaskExecutor taskExecutor;

    public MongoBatchConfigurer(Datastore datastore, TaskExecutor taskExecutor) {
        this.mongoExecutionContextDao = new ExecutionContextRepository(datastore);
        this.mongoJobExecutionDao = new JobExecutionRepository(datastore);
        this.mongoJobInstanceDao = new JobInstanceRepository(datastore);
        this.mongoStepExecutionDao = new StepExecutionRepository(datastore);
        this.taskExecutor = taskExecutor;
    }

    public JobRepository getJobRepository() throws Exception {
        return new SimpleJobRepository(this.mongoJobInstanceDao, this.mongoJobExecutionDao, this.mongoStepExecutionDao, this.mongoExecutionContextDao);
    }

    public PlatformTransactionManager getTransactionManager() throws Exception {
        return new ResourcelessTransactionManager();
    }

    public JobLauncher getJobLauncher() throws Exception {
        SimpleJobLauncher jobLauncher = new SimpleJobLauncher();
        jobLauncher.setJobRepository(this.getJobRepository());
        jobLauncher.setTaskExecutor(this.taskExecutor);
        jobLauncher.afterPropertiesSet();
        return jobLauncher;
    }

    public JobExplorer getJobExplorer() throws Exception {
        return new SimpleJobExplorer(this.mongoJobInstanceDao, this.mongoJobExecutionDao, this.mongoStepExecutionDao, this.mongoExecutionContextDao);
    }
}

