/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.web;

import eu.europeana.api.recommend.exception.InvalidRecordIdException;
import eu.europeana.api.recommend.exception.NoCredentialsException;
import eu.europeana.api.recommend.exception.RecommendException;
import eu.europeana.api.recommend.model.SearchAPIEmptyResponse;
import eu.europeana.api.recommend.service.RecommendService;
import eu.europeana.api.recommend.service.TokenUtils;
import io.micrometer.core.instrument.util.StringUtils;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@Validated
public class RecommendController {
    private static final Logger LOG = LogManager.getLogger(RecommendController.class);
    private static final String SET_ID_REGEX = "^[0-9]*$";
    private static final String ENTITY_ID_REGEX = "^[0-9]*$";
    private static final String ENTITY_BASE_REGEX = "^(?i)base$";
    private static final String ENTITY_TYPE_REGEX = "^(?i)[agent|concept|place]*$";
    private static final String EUROPEANA_ID_FIELD_REGEX = "^[a-zA-Z0-9_]*$";
    private static final String APIKEY_REGEX = "^[a-zA-Z0-9_]*$";
    private static final String SEED_REGEX = "-?[1-9]\\d*|0";
    private static final String DEFAULT_PAGE_SIZE = "10";
    private static final int MAX_PAGE_SIZE = 50;
    private static final String DEFAULT_PAGE = "0";
    private static final int MAX_PAGE = 40;
    private static final String INVALID_SET_ID_MESSAGE = "Invalid set identifier";
    private static final String INVALID_ENTITY_ID_MESSAGE = "Invalid entity identifier. Id is not a number  ";
    private static final String INVALID_ENTITY_TYPE_MESSAGE = "Invalid entity identifier. Valid types are agent, concept and place";
    private static final String INVALID_ENTITY_BASE_MESSAGE = "Invalid entity identifier. Missing 'base' keyword";
    private static final String INVALID_RECORD_ID_MESSAGE = "Invalid record identifier. Only alpha-numeric characters and underscore are allowed";
    private static final String INCORRECT_PAGE_SIZE = "The page size is not a number between 1 and 50";
    private static final String INCORRECT_PAGE = "The page value is not a number between 0 and 40";
    private static final String INVALID_SEED_MESSAGE = "Invalid seed value. Seed is an Integer, only numbers are allowed";
    private static final String INVALID_APIKEY_MESSAGE = "Invalid API key format";
    private static final java.util.regex.Pattern EUROPEANA_ID = java.util.regex.Pattern.compile("^/[a-zA-Z0-9_]*/[a-zA-Z0-9_]*$");
    private RecommendService recommendService;

    public RecommendController(RecommendService recommendService) {
        this.recommendService = recommendService;
    }

    @GetMapping(value={"/recommend/set/{setId}.json", "/recommend/set/{setId}", "/set/{setId}/recommend.json", "/set/{setId}/recommend"}, produces={"application/json"})
    public ResponseEntity recommendSet(@PathVariable(value="setId") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") String setId, @RequestParam(value="pageSize", required=false, defaultValue="10") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") int pageSize, @RequestParam(value="page", required=false, defaultValue="0") @Min(value=0L, message="The page value is not a number between 0 and 40") @Max(value=40L, message="The page value is not a number between 0 and 40") @Min(value=0L, message="The page value is not a number between 0 and 40") @Max(value=40L, message="The page value is not a number between 0 and 40") int page, @RequestParam(value="seed", required=false) @Pattern(regexp="-?[1-9]\\d*|0", message="Invalid seed value. Seed is an Integer, only numbers are allowed") @Pattern(regexp="-?[1-9]\\d*|0", message="Invalid seed value. Seed is an Integer, only numbers are allowed") String seed, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String apikey = this.checkCredentials(authToken, wskey, false);
        Mono result = this.recommendService.getRecommendationsForSet(setId, pageSize, page, seed, authToken, apikey);
        if (result == null) {
            return new ResponseEntity((Object)new SearchAPIEmptyResponse(apikey), HttpStatus.OK);
        }
        return new ResponseEntity(result.block(), HttpStatus.OK);
    }

    @PostMapping(value={"/recommend/set/{setId}.json", "/recommend/set/{setId}", "/set/{setId}/recommend.json", "/set/{setId}/recommend"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity acceptSet(@PathVariable(value="setId") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") String setId, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendSet(setId, ids.length, 0, null, wskey, authToken);
    }

    @DeleteMapping(value={"/recommend/set/{setId}.json", "/recommend/set/{setId}", "/set/{setId}/recommend.json", "/set/{setId}/recommend"}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity rejectSet(@PathVariable(value="setId") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") String setId, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendSet(setId, ids.length, 0, null, wskey, authToken);
    }

    @GetMapping(value={"/recommend/entity/{type}/{base}/{id}.json", "/recommend/entity/{type}/{base}/{id}", "/entity/{type}/{base}/{id}/recommend.json", "/entity/{type}/{base}/{id}/recommend"}, produces={"application/json"})
    public ResponseEntity recommendEntity(@PathVariable(value="type") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") String type, @PathVariable(value="base") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") String base, @PathVariable(value="id") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") String id, @RequestParam(value="pageSize", required=false, defaultValue="10") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") int pageSize, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String apikey = this.checkCredentials(authToken, wskey, false);
        Mono result = this.recommendService.getRecommendationsForEntity(type, id, pageSize, authToken, apikey);
        if (result == null) {
            return new ResponseEntity((Object)new SearchAPIEmptyResponse(apikey), HttpStatus.OK);
        }
        return new ResponseEntity(result.block(), HttpStatus.OK);
    }

    @PostMapping(value={"/recommend/entity/{type}/{base}/{id}.json", "/recommend/entity/{type}/{base}/{id}", "/entity/{type}/{base}/{id}/recommend.json", "/entity/{type}/{base}/{id}/recommend"}, produces={"application/json"})
    public ResponseEntity acceptEntity(@PathVariable(value="type") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") String type, @PathVariable(value="base") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") String base, @PathVariable(value="id") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") String id, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendEntity(type, base, id, ids.length, wskey, authToken);
    }

    @DeleteMapping(value={"/recommend/entity/{type}/{base}/{id}.json", "/recommend/entity/{type}/{base}/{id}", "/entity/{type}/{base}/{id}/recommend.json", "/entity/{type}/{base}/{id}/recommend"}, produces={"application/json"})
    public ResponseEntity rejectEntity(@PathVariable(value="type") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") @Pattern(regexp="^(?i)[agent|concept|place]*$", message="Invalid entity identifier. Valid types are agent, concept and place") String type, @PathVariable(value="base") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") @Pattern(regexp="^(?i)base$", message="Invalid entity identifier. Missing 'base' keyword") String base, @PathVariable(value="id") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") @Pattern(regexp="^[0-9]*$", message="Invalid entity identifier. Id is not a number  ") String id, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendEntity(type, base, id, ids.length, wskey, authToken);
    }

    @GetMapping(value={"/recommend/record/{datasetId}/{localId}.json", "/recommend/record/{datasetId}/{localId}", "/record/{datasetId}/{localId}/recommend.json", "/record/{datasetId}/{localId}/recommend"}, produces={"application/json"})
    public ResponseEntity recommendRecord(@PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, @RequestParam(value="pageSize", required=false, defaultValue="10") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") int pageSize, @RequestParam(value="page", required=false, defaultValue="0") @Min(value=0L, message="The page value is not a number between 0 and 40") @Max(value=40L, message="The page value is not a number between 0 and 40") @Min(value=0L, message="The page value is not a number between 0 and 40") @Max(value=40L, message="The page value is not a number between 0 and 40") int page, @RequestParam(value="seed", required=false) @Pattern(regexp="-?[1-9]\\d*|0", message="Invalid seed value. Seed is an Integer, only numbers are allowed") @Pattern(regexp="-?[1-9]\\d*|0", message="Invalid seed value. Seed is an Integer, only numbers are allowed") String seed, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String apikey = this.checkCredentials(authToken, wskey, false);
        String recordId = "/" + datasetId + "/" + localId;
        Mono result = this.recommendService.getRecommendationsForRecord(recordId, pageSize, page, seed, authToken, apikey);
        if (result == null) {
            return new ResponseEntity((Object)new SearchAPIEmptyResponse(apikey), HttpStatus.OK);
        }
        return new ResponseEntity(result.block(), HttpStatus.OK);
    }

    @PostMapping(value={"/recommend/record/{datasetId}/{localId}.json", "/recommend/record/{datasetId}/{localId}", "/record/{datasetId}/{localId}/recommend.json", "/record/{datasetId}/{localId}/recommend"}, produces={"application/json"})
    public ResponseEntity acceptRecord(@PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendRecord(datasetId, localId, ids.length, 0, null, wskey, authToken);
    }

    @DeleteMapping(value={"/recommend/record/{datasetId}/{localId}.json", "/recommend/record/{datasetId}/{localId}", "/record/{datasetId}/{localId}/recommend.json", "/record/{datasetId}/{localId}/recommend"}, produces={"application/json"})
    public ResponseEntity rejectRecord(@PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @Valid @RequestBody String[] ids, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String userId = this.checkCredentials(authToken, wskey, true);
        return this.recommendRecord(datasetId, localId, ids.length, 0, null, wskey, authToken);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String checkCredentials(String authToken, String wskey, boolean getUserFromToken) throws RecommendException {
        String apikeyOrUser;
        if (StringUtils.isBlank((String)wskey) && StringUtils.isBlank((String)authToken)) {
            throw new NoCredentialsException();
        }
        if (getUserFromToken) {
            if (!StringUtils.isNotBlank((String)authToken)) throw new NoCredentialsException("User is not authorised to perform this action");
            apikeyOrUser = TokenUtils.getUserId((String)authToken);
            LOG.debug("User {} fetched from the token", (Object)apikeyOrUser);
            return apikeyOrUser;
        } else if (StringUtils.isNotBlank((String)authToken)) {
            apikeyOrUser = TokenUtils.getApiKey((String)authToken);
            LOG.debug("Using API key {} from token", (Object)apikeyOrUser);
            return apikeyOrUser;
        } else {
            apikeyOrUser = wskey;
            LOG.debug("Using received API key {}", (Object)apikeyOrUser);
        }
        return apikeyOrUser;
    }

    private void validateRecordIds(String[] ids) throws RecommendException {
        if (ids == null || ids.length == 0) {
            throw new InvalidRecordIdException("No ids provided");
        }
        for (String id : ids) {
            if (this.isValidRecordId(id)) continue;
            throw new InvalidRecordIdException(id);
        }
    }

    private boolean isValidRecordId(String id) {
        return EUROPEANA_ID.matcher(id).matches();
    }
}

