/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.util;

import eu.europeana.api.recommend.config.SocksProxyConfig;
import eu.europeana.api.recommend.util.SocksProxyActivator;
import io.micrometer.core.instrument.util.StringUtils;
import java.net.Authenticator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SocksProxyActivator {
    private static final Logger LOG = LogManager.getLogger(SocksProxyActivator.class);

    private SocksProxyActivator() {
    }

    public static boolean activate(SocksProxyConfig config) {
        if (!SocksProxyActivator.isValidConfiguration((SocksProxyConfig)config)) {
            return false;
        }
        System.setProperty("socksProxyHost", config.getHost());
        System.setProperty("socksProxyPort", config.getPort());
        String user = config.getUser();
        if (StringUtils.isNotBlank((String)user)) {
            String pass = config.getPassword();
            System.setProperty("java.net.socks.username", user);
            System.setProperty("java.net.socks.password", pass);
            Authenticator.setDefault((Authenticator)new SockProxyAuthenticator(user, pass));
        }
        return true;
    }

    private static boolean isValidConfiguration(SocksProxyConfig config) {
        boolean result = false;
        if (StringUtils.isEmpty((String)config.getHost())) {
            LOG.info("No socks proxy configured");
        } else if (!config.isSocksEnabled()) {
            LOG.info("Socks proxy disabled");
        } else {
            LOG.info("Setting up socks proxy at {}", (Object)config.getHost());
            result = true;
        }
        return result;
    }
}

