/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class EntityAPIUtils {
    private static final Logger LOG = LogManager.getLogger(EntityAPIUtils.class);
    private static final String ITEMS_FIELD = "items";
    private static final String PREF_LABEL_FIELD = "prefLabel";
    private static final String ALT_LABEL_FIELD = "altLabel";
    public static final String TOTAL = "total";

    private EntityAPIUtils() {
    }

    public static String buildEntityId(String type, String id) {
        StringBuilder entityId = new StringBuilder("http://data.europeana.eu");
        entityId.append("/").append(type);
        entityId.append("/base/").append(id);
        return entityId.toString();
    }

    public static String entityApiSearchQuery(String entityUri, String wskey) {
        StringBuilder query = new StringBuilder("?query=entity_uri:");
        query.append("\"").append(entityUri).append("\"");
        query.append("&fl=skos_prefLabel.*,skos_altLabel.*");
        query.append("&").append("wskey=").append(wskey);
        return query.toString();
    }

    public static List<String> extractLabels(JSONObject jsonObject) throws JSONException {
        ArrayList<String> labels = new ArrayList<String>();
        JSONArray items = jsonObject.getJSONArray("items");
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item = (JSONObject)items.get(i);
            if (item.has("prefLabel")) {
                JSONObject prefLabel = item.getJSONObject("prefLabel");
                labels.addAll(EntityAPIUtils.getPreflabels((String)prefLabel.toString()));
            }
            if (!item.has("altLabel")) continue;
            JSONObject altLabel = item.getJSONObject("altLabel");
            labels.addAll(EntityAPIUtils.getAltLabels((String)altLabel.toString()));
        }
        return labels;
    }

    private static Collection<String> getPreflabels(String prefLabels) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return ((HashMap)mapper.readValue(prefLabels, (TypeReference)new /* Unavailable Anonymous Inner Class!! */)).values();
        }
        catch (JsonProcessingException e) {
            LOG.error("Error reading the prefLabels.", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    private static List<String> getAltLabels(String altLabels) {
        ArrayList<String> altLabel = new ArrayList<String>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(altLabels, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            map.entrySet().stream().forEach(entry -> {
                for (String value : (List)entry.getValue()) {
                    altLabel.add(value);
                }
            });
        }
        catch (JsonProcessingException e) {
            LOG.error("Error reading the altLabels.", (Throwable)e);
        }
        return altLabel;
    }
}

