/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import eu.europeana.api.recommend.exception.InvalidTokenException;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Locale;

/*
 * Exception performing whole class analysis ignored.
 */
public final class TokenUtils {
    private static final String API_KEY_CLAIM = "azp";
    private static final String USER_CLAIM = "sub";

    private TokenUtils() {
    }

    public static String getApiKey(String token) throws InvalidTokenException {
        return TokenUtils.getClaimFromToken((String)TokenUtils.getToken((String)token), (String)"azp");
    }

    public static String getUserId(String token) throws InvalidTokenException {
        return TokenUtils.getClaimFromToken((String)TokenUtils.getToken((String)token), (String)"sub");
    }

    private static String getClaimFromToken(String token, String claim) throws InvalidTokenException {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            String result = jwt.getClaim(claim).asString();
            if (StringUtils.isBlank((String)result)) {
                throw new InvalidTokenException("Token does not contain '" + claim + "' field");
            }
            return result;
        }
        catch (JWTDecodeException e) {
            throw new InvalidTokenException("Error decoding authorization token", (Throwable)e);
        }
    }

    private static String getToken(String token) throws InvalidTokenException {
        if (token.toLowerCase(Locale.GERMAN).startsWith("bearer ")) {
            return token.substring("Bearer ".length());
        }
        throw new InvalidTokenException("Invalid Token provided");
    }
}

