/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.recommend.config.RecommendSettings;
import eu.europeana.api.recommend.config.WebClients;
import eu.europeana.api.recommend.exception.EntityNotFoundException;
import eu.europeana.api.recommend.model.EntityRecommendRequest;
import eu.europeana.api.recommend.model.Labels;
import eu.europeana.api.recommend.model.UserSignalRequest;
import eu.europeana.api.recommend.util.EntityAPIUtils;
import eu.europeana.api.recommend.util.SearchAPIUtils;
import eu.europeana.api.recommend.util.SetAPIUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class RecommendService {
    private static final Logger LOG = LogManager.getLogger(RecommendService.class);
    private RecommendSettings config;
    private WebClient searchApiClient;
    private WebClient entityApiClient;
    private WebClient setApiClient;
    private WebClient rengineClient;

    public RecommendService(RecommendSettings config, WebClients webClients) {
        this.config = config;
        this.searchApiClient = webClients.getSearchApiClient();
        this.entityApiClient = webClients.getEntityApiClient();
        this.setApiClient = webClients.getSetApiClient();
        this.rengineClient = webClients.getRecommendEngineClient();
    }

    public Mono getRecommendationsForSet(String setId, int pageSize, int page, String seed, String token, String apikey) {
        String[] recommendedIds;
        StringBuilder s = new StringBuilder(this.config.getREngineRecommendPath()).append("?bucket=").append(setId).append("&size=").append(pageSize).append("&skip=").append(pageSize * page);
        if (seed != null) {
            s.append("&seed=").append(seed);
        }
        if ((recommendedIds = (String[])this.getRecommendations(s.toString(), null, token, apikey).block()) == null || recommendedIds.length == 0) {
            LOG.warn("No recommended records for set {}", (Object)setId);
            return null;
        }
        LOG.debug("Recommend engine returned {} items for set {}", (Object)recommendedIds.length, (Object)setId);
        return this.getSearchApiResponse(recommendedIds, pageSize, apikey);
    }

    public void submitUserSignals(String[] ids, String signalType, String userId, String token, String apikey) {
        StringBuilder s = new StringBuilder(this.config.getREngineEventsPath());
        String requestBody = this.getSubmitUserSignalRequest(ids, signalType, userId);
        String[] response = (String[])this.getRecommendations(s.toString(), requestBody, token, apikey).block();
        if (response == null || response.length == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Signal {} submitted successfully for {}", (Object)signalType.toUpperCase(Locale.ROOT), (Object)Arrays.toString(ids));
            }
        } else {
            LOG.warn("No response from recommendation engine for {}", (Object)Arrays.toString(ids));
        }
    }

    private String getSubmitUserSignalRequest(String[] ids, String signalType, String userId) {
        ArrayList<UserSignalRequest> request = new ArrayList<UserSignalRequest>();
        for (String id : ids) {
            request.add(new UserSignalRequest(userId, id, signalType));
        }
        return this.serialiseRequest(request);
    }

    public Mono getRecommendationsForRecord(String recordId, int pageSize, int page, String seed, String token, String apikey) {
        String[] recommendedIds;
        StringBuilder s = new StringBuilder(this.config.getREngineRecommendPath()).append("?item=").append(recordId).append("&size=").append(pageSize).append("&skip=").append(pageSize * page);
        if (seed != null) {
            s.append("&seed=").append(seed);
        }
        if ((recommendedIds = (String[])this.getRecommendations(s.toString(), null, token, apikey).block()) == null || recommendedIds.length == 0) {
            LOG.warn("No recommended records for record {}", (Object)recordId);
            return null;
        }
        LOG.debug("Recommend engine returned {} items for record {}", (Object)recommendedIds.length, (Object)recordId);
        return this.getSearchApiResponse(recommendedIds, pageSize, apikey);
    }

    public Mono getRecommendationsForEntity(String type, String id, int pageSize, String token, String apikey) throws EntityNotFoundException {
        String entityId = EntityAPIUtils.buildEntityId((String)type, (String)id);
        String requestBody = this.getEntityRecommendationRequest(entityId, apikey);
        StringBuilder s = new StringBuilder(this.config.getREngineRecommendPath()).append("/entity").append("?size=").append(pageSize);
        String[] recommendedIds = (String[])this.getRecommendations(s.toString(), requestBody, token, apikey).block();
        if (recommendedIds == null || recommendedIds.length == 0) {
            LOG.warn("No recommended records for entity {}", (Object)entityId);
            return null;
        }
        LOG.debug("Recommend engine returned {} items for entity {} : {}", (Object)recommendedIds.length, (Object)entityId, (Object)recommendedIds);
        return this.getSearchApiResponse(recommendedIds, pageSize, apikey);
    }

    public String getEntityRecommendationRequest(String entityId, String apikey) throws EntityNotFoundException {
        EntityRecommendRequest request = new EntityRecommendRequest();
        StringBuilder entityApiUrl = new StringBuilder(this.config.getEntityApiEndpoint()).append(EntityAPIUtils.entityApiSearchQuery((String)entityId, (String)apikey));
        this.getLabels(request, entityApiUrl.toString(), entityId);
        StringBuilder setApiUrl = new StringBuilder(this.config.getSetApiEndpoint()).append(SetAPIUtils.setApiSearchQuery((String)entityId, (String)this.config.getSetApiPageSize(), (String)apikey));
        this.getItems(request, setApiUrl.toString());
        return this.serialiseRequest((Object)request);
    }

    private void getLabels(EntityRecommendRequest request, String entityUrl, String entityId) throws EntityNotFoundException {
        try {
            String response = (String)this.entityApiClient.get().uri(entityUrl, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().bodyToMono(String.class).block();
            JSONObject jsonObject = new JSONObject(response);
            if (!this.checkIfEntityExists(jsonObject)) {
                throw new EntityNotFoundException("Entity " + entityId + " not found.");
            }
            List extractedLabels = EntityAPIUtils.extractLabels((JSONObject)jsonObject);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} labels for entity {}", (Object)extractedLabels.size(), (Object)entityId);
            }
            ArrayList<Labels> labels = new ArrayList<Labels>();
            if (!extractedLabels.isEmpty()) {
                for (String label : extractedLabels) {
                    labels.add(new Labels(label));
                }
                request.setLabels(labels);
            } else {
                labels.add(new Labels(""));
                request.setLabels(labels);
            }
        }
        catch (JSONException e) {
            LOG.error("Error parsing entity api response for url {}. {}", (Object)entityUrl, (Object)e);
        }
    }

    private void getItems(EntityRecommendRequest request, String setApiUrl) {
        try {
            String response = (String)this.setApiClient.get().uri(setApiUrl, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().bodyToMono(String.class).block();
            JSONObject jsonObject = new JSONObject(response);
            if (this.checkIfEntityExists(jsonObject)) {
                List items = SetAPIUtils.extractItems((JSONObject)jsonObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} results from Set API", (Object)items.size());
                }
                if (!items.isEmpty()) {
                    request.setItems(items.toArray(new String[0]));
                }
            }
        }
        catch (JSONException e) {
            LOG.error("Error parsing set api response for url {}. {}", (Object)setApiUrl, (Object)e);
        }
    }

    private boolean checkIfEntityExists(JSONObject jsonObject) throws JSONException {
        return Integer.parseInt(String.valueOf(jsonObject.get("total"))) != 0;
    }

    private String serialiseRequest(Object request) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error serialising the {} recommendation request. ", request.getClass(), (Object)e);
            return "";
        }
    }

    private Mono<String[]> getRecommendations(String recommendQuery, String jsonBody, String token, String apikey) {
        Object authValue = token;
        if (StringUtils.isBlank((String)authValue)) {
            authValue = "APIKEY " + apikey;
        }
        if (jsonBody != null) {
            return this.executePostRequest(recommendQuery, jsonBody, (String)authValue);
        }
        return this.executeGetRequest(recommendQuery, (String)authValue);
    }

    private Mono<String[]> executeGetRequest(String recommendQuery, String authValue) {
        return this.rengineClient.get().uri(recommendQuery, new Object[0]).header("Accept", new String[]{"application/json"}).header("Authorization", new String[]{authValue}).retrieve().bodyToMono(String[].class);
    }

    private Mono<String[]> executePostRequest(String recommendQuery, String jsonBody, String authValue) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("  POST Body = {}", (Object)jsonBody);
        }
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.rengineClient.post().uri(recommendQuery, new Object[0])).header("Content-Type", new String[]{"application/json"})).header("Authorization", new String[]{authValue})).body(BodyInserters.fromValue((Object)jsonBody)).retrieve().bodyToMono(String[].class);
    }

    private Mono getSearchApiResponse(String[] recordIds, int maxResults, String wskey) {
        String query = SearchAPIUtils.generateSearchQuery((String[])recordIds, (int)maxResults, (String)wskey);
        Mono response = this.searchApiClient.get().uri(query, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().bodyToMono(Object.class);
        if (LOG.isDebugEnabled()) {
            LinkedHashMap map = (LinkedHashMap)response.block();
            Integer nrResults = (Integer)map.get("totalResults");
            if (nrResults != recordIds.length) {
                LOG.warn("{} results from Search API, expected {}", (Object)nrResults, (Object)recordIds.length);
            } else {
                LOG.debug("{} results from Search API", (Object)nrResults);
            }
        }
        return response;
    }
}

