/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.exception;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.europeana.api.recommend.config.RecommendSettings;
import eu.europeana.api.recommend.exception.RecommendException;
import eu.europeana.api.recommend.model.SearchAPIError;
import io.micrometer.core.instrument.util.StringEscapeUtils;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.MissingRequestHeaderException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@ControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger LOG = LogManager.getLogger(GlobalExceptionHandler.class);
    private static final ObjectMapper JSON_ERROR_TO_OBJECT = new ObjectMapper();
    private RecommendSettings config;

    public GlobalExceptionHandler(RecommendSettings config) {
        this.config = config;
    }

    @ExceptionHandler(value={RecommendException.class})
    public void handleBaseException(RecommendException e) throws RecommendException {
        if (e.doLog()) {
            if (e.logStacktrace()) {
                LOG.error("Caught exception", (Throwable)e);
            } else {
                LOG.error("Caught exception: {}", (Object)e.getMessage());
            }
        }
        throw e;
    }

    @ExceptionHandler
    public void handleMissingAuthHeader(MissingRequestHeaderException e, HttpServletResponse response) throws IOException {
        if ("Authorization".equalsIgnoreCase(e.getHeaderName())) {
            response.sendError(HttpStatus.UNAUTHORIZED.value(), StringEscapeUtils.escapeJson((String)e.getMessage()));
        } else {
            response.sendError(HttpStatus.BAD_REQUEST.value(), StringEscapeUtils.escapeJson((String)e.getMessage()));
        }
    }

    @ExceptionHandler
    public void handleInputValidationError(ConstraintViolationException e, HttpServletResponse response) throws IOException {
        response.sendError(HttpStatus.BAD_REQUEST.value(), StringEscapeUtils.escapeJson((String)e.getMessage()));
    }

    @ExceptionHandler(value={WebClientResponseException.class})
    public void handleWebClientResponseException(WebClientResponseException ex, HttpServletResponse response) throws IOException {
        Object errorMsg;
        LOG.error("Error from backend: {} {} (Message = {})", (Object)ex.getRawStatusCode(), (Object)ex.getStatusText(), (Object)ex.getMessage());
        if (this.isRequestFromSearchAPI(ex)) {
            errorMsg = "Error from backend API: ";
            if (StringUtils.isNotBlank((String)ex.getResponseBodyAsString())) {
                try {
                    SearchAPIError searchApiError = (SearchAPIError)JSON_ERROR_TO_OBJECT.readValue(ex.getResponseBodyAsString(), SearchAPIError.class);
                    errorMsg = (String)errorMsg + searchApiError.getError();
                }
                catch (JsonProcessingException e) {
                    LOG.warn("Cannot deserialize error response from Search API: {}", (Object)ex.getResponseBodyAsString(), (Object)e);
                    errorMsg = (String)errorMsg + ex.getMessage();
                }
            } else {
                errorMsg = (String)errorMsg + ex.getMessage();
            }
        } else {
            errorMsg = "Error from backend engine: " + ex.getMessage();
        }
        if (ex.getRawStatusCode() == HttpStatus.INTERNAL_SERVER_ERROR.value()) {
            response.sendError(HttpStatus.BAD_GATEWAY.value(), StringEscapeUtils.escapeJson((String)this.filterOutSensitiveInformation((String)errorMsg)));
        } else {
            response.sendError(ex.getRawStatusCode(), StringEscapeUtils.escapeJson((String)this.filterOutSensitiveInformation((String)errorMsg)));
        }
    }

    private boolean isRequestFromSearchAPI(WebClientResponseException ex) {
        if (ex.getRequest() != null) {
            return this.config.getSearchApiHost().contains(ex.getRequest().getURI().getHost());
        }
        return false;
    }

    private String filterOutSensitiveInformation(String originalMessage) {
        String result = originalMessage.replaceAll(this.config.getREngineHost(), "<ENGINE_HOST>");
        result = result.replaceAll(this.config.getSearchApiEndpoint(), "<SEARCH_API_ENDPOINT>");
        return result;
    }

    static {
        JSON_ERROR_TO_OBJECT.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }
}

