/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.config;

import eu.europeana.api.recommend.config.BuildInfo;
import eu.europeana.api.recommend.config.RecommendSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class WebClients {
    private static final Logger LOG = LogManager.getLogger(WebClients.class);
    private RecommendSettings config;
    private BuildInfo buildInfo;
    private int maxInMemSizeMb = 10;

    public WebClients(RecommendSettings config, BuildInfo buildInfo) {
        this.config = config;
        this.buildInfo = buildInfo;
        if (null != config.getMaxInMemSizeMb()) {
            this.maxInMemSizeMb = config.getMaxInMemSizeMb();
        }
    }

    @Bean
    public WebClient getSearchApiClient() {
        return this.getApiClient(this.config.getSearchApiEndpoint(), true);
    }

    @Bean
    public WebClient getRecommendEngineClient() {
        return this.getApiClient(this.config.getREngineHost(), false);
    }

    @Bean
    public WebClient getEntityApiClient() {
        return this.getApiClient(this.config.getEntityApiEndpoint(), true);
    }

    @Bean
    public WebClient getSetApiClient() {
        return this.getApiClient(this.config.getSetApiEndpoint(), true);
    }

    private WebClient getApiClient(String apiEndpoint, boolean exchangeStrategy) {
        WebClient.Builder webClientBuilder = WebClient.builder();
        if (exchangeStrategy) {
            webClientBuilder.exchangeStrategies(ExchangeStrategies.builder().codecs(configurer -> configurer.defaultCodecs().maxInMemorySize(this.maxInMemSizeMb * 1024 * 1024)).build());
        }
        return webClientBuilder.baseUrl(apiEndpoint).defaultHeader("User-Agent", new String[]{this.generateUserAgentName()}).filter(this.logRequest()).build();
    }

    private String generateUserAgentName() {
        return this.buildInfo.getAppName() + " v" + this.buildInfo.getAppVersion();
    }

    private ExchangeFilterFunction logRequest() {
        return (clientRequest, next) -> {
            LOG.debug("Request: {} {}", (Object)clientRequest.method(), (Object)clientRequest.url());
            return next.exchange(clientRequest);
        };
    }
}

