/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.config;

import java.util.Locale;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.stereotype.Component;

@Configuration
@Component
@PropertySources(value={@PropertySource(value={"classpath:recommend.properties"}), @PropertySource(value={"classpath:recommend.user.properties"}, ignoreResourceNotFound=true)})
public class RecommendSettings {
    private static final Logger LOG = LogManager.getLogger(RecommendSettings.class);
    @Value(value="${search.api.host}")
    private String searchApiHost;
    @Value(value="${search.api.endpoint}")
    private String searchApiEndpoint;
    @Value(value="${entity.api.endpoint}")
    private String entityApiEndpoint;
    @Value(value="${set.api.endpoint}")
    private String setApiEndpoint;
    @Value(value="${set.api.pagesize}")
    private String setApiPageSize;
    @Value(value="${recommend.engine.host}")
    private String rengineHost;
    @Value(value="${recommend.engine.recommend.path}")
    private String rengineRecommendPath;
    @Value(value="${recommend.engine.events.path}")
    private String rengineEventsPath;
    @Value(value="${webclient.max.memsizemb:10}")
    private String maxInMemSizeMb;

    public String getSearchApiHost() {
        return this.searchApiHost;
    }

    public String getSearchApiEndpoint() {
        return this.searchApiEndpoint;
    }

    public String getREngineHost() {
        return this.rengineHost;
    }

    public String getREngineRecommendPath() {
        return this.rengineRecommendPath;
    }

    public String getREngineEventsPath() {
        return this.rengineEventsPath;
    }

    public String getEntityApiEndpoint() {
        return this.entityApiEndpoint;
    }

    public String getSetApiEndpoint() {
        return this.setApiEndpoint;
    }

    public String getSetApiPageSize() {
        return this.setApiPageSize;
    }

    public Integer getMaxInMemSizeMb() {
        if (StringUtils.isNumeric((CharSequence)this.maxInMemSizeMb)) {
            return Integer.parseInt(this.maxInMemSizeMb);
        }
        if (StringUtils.isNotBlank((CharSequence)this.maxInMemSizeMb)) {
            LOG.error("Value webclient.max.memsizemb is not numeric: {}", (Object)this.maxInMemSizeMb);
        }
        return null;
    }

    @PostConstruct
    private void logImportantSettings() {
        this.searchApiEndpoint = this.addProtocolIfMissing(this.searchApiEndpoint);
        this.rengineHost = this.addProtocolIfMissing(this.rengineHost);
        LOG.info("Recommendation API settings:");
        LOG.info("  Search API endpoint: {}", (Object)this.searchApiEndpoint);
        LOG.info("  Recommender engine host: {}", (Object)this.rengineHost);
    }

    private String addProtocolIfMissing(String hostName) {
        String host = hostName.toLowerCase(Locale.GERMAN);
        if (!host.startsWith("https://") && !host.startsWith("http://")) {
            return "https://" + host;
        }
        return host;
    }
}

