/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.web;

import eu.europeana.api.recommend.exception.NoCredentialsException;
import eu.europeana.api.recommend.exception.RecommendException;
import eu.europeana.api.recommend.model.SearchAPIEmptyResponse;
import eu.europeana.api.recommend.service.RecommendService;
import eu.europeana.api.recommend.service.TokenUtils;
import io.micrometer.core.instrument.util.StringUtils;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/recommend"})
@Validated
public class RecommendController {
    private static final Logger LOG = LogManager.getLogger(RecommendController.class);
    private static final String SET_ID_REGEX = "^[0-9]*$";
    private static final String EUROPEANA_ID_REGEX = "^[a-zA-Z0-9_]*$";
    private static final String APIKEY_REGEX = "^[a-zA-Z0-9_]*$";
    private static final String DEFAULT_PAGE_SIZE = "10";
    private static final int MAX_PAGE_SIZE = 50;
    private static final String INVALID_SETID_MESSAGE = "Invalid set identifier";
    private static final String INVALID_RECORDID_MESSAGE = "Invalid record identifier. Only alpha-numeric characters and underscore are allowed";
    private static final String INCORRECT_PAGE_SIZE = "The page size is not a number between 1 and 50";
    private static final String INVALID_APIKEY_MESSAGE = "Invalid API key format";
    private RecommendService recommendService;

    public RecommendController(RecommendService recommendService) {
        this.recommendService = recommendService;
    }

    @GetMapping(value={"/set/{setId}.json", "/set/{setId}"}, produces={"application/json"})
    public ResponseEntity recommendSet(@PathVariable(value="setId") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") @Pattern(regexp="^[0-9]*$", message="Invalid set identifier") String setId, @RequestParam(value="pageSize", required=false, defaultValue="10") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") int pageSize, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String apikey = this.checkCredentials(authToken, wskey);
        Mono result = this.recommendService.getRecommendationsForSet(setId, pageSize, authToken, apikey);
        if (result == null) {
            return new ResponseEntity((Object)new SearchAPIEmptyResponse(apikey), HttpStatus.OK);
        }
        return new ResponseEntity(result.block(), HttpStatus.OK);
    }

    @GetMapping(value={"/record/{datasetId}/{localId}.json", "/record/{datasetId}/{localId}"}, produces={"application/json"})
    public ResponseEntity recommendRecord(@PathVariable(value="datasetId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String datasetId, @PathVariable(value="localId") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid record identifier. Only alpha-numeric characters and underscore are allowed") String localId, @RequestParam(value="pageSize", required=false, defaultValue="10") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") @Min(value=1L, message="The page size is not a number between 1 and 50") @Max(value=50L, message="The page size is not a number between 1 and 50") int pageSize, @RequestParam(value="wskey", required=false) @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") @Pattern(regexp="^[a-zA-Z0-9_]*$", message="Invalid API key format") String wskey, @RequestHeader(value="Authorization", required=false) String authToken) throws RecommendException {
        String apikey = this.checkCredentials(authToken, wskey);
        String recordId = "/" + datasetId + "/" + localId;
        Mono result = this.recommendService.getRecommendationsForRecord(recordId, pageSize, authToken, apikey);
        if (result == null) {
            return new ResponseEntity((Object)new SearchAPIEmptyResponse(apikey), HttpStatus.OK);
        }
        return new ResponseEntity(result.block(), HttpStatus.OK);
    }

    private String checkCredentials(String authToken, String wskey) throws RecommendException {
        String apikey;
        if (StringUtils.isBlank((String)wskey) && StringUtils.isBlank((String)authToken)) {
            throw new NoCredentialsException();
        }
        if (StringUtils.isNotBlank((String)authToken)) {
            apikey = TokenUtils.getApiKey((String)authToken);
            LOG.debug("Using API key {} from token", (Object)apikey);
        } else {
            apikey = wskey;
            LOG.debug("Using received API key {}", (Object)apikey);
        }
        return apikey;
    }
}

