/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import eu.europeana.api.recommend.exception.InvalidTokenException;
import io.micrometer.core.instrument.util.StringUtils;
import java.util.Locale;

public class TokenUtils {
    private static final String API_KEY_CLAIM = "azp";

    private TokenUtils() {
    }

    public static String getApiKey(String token) throws InvalidTokenException {
        String tkn = token;
        if (token.toLowerCase(Locale.GERMAN).startsWith("bearer ")) {
            tkn = token.substring("Bearer ".length());
        }
        try {
            DecodedJWT jwt = JWT.decode((String)tkn);
            String result = jwt.getClaim(API_KEY_CLAIM).asString();
            if (StringUtils.isBlank((String)result)) {
                throw new InvalidTokenException("Token does not contain 'azp' field");
            }
            return result;
        }
        catch (JWTDecodeException e) {
            throw new InvalidTokenException("Error decoding authorization token", (Throwable)e);
        }
    }
}

