/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.service;

import eu.europeana.api.recommend.config.RecommendSettings;
import eu.europeana.api.recommend.config.WebClients;
import io.micrometer.core.instrument.util.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Service
public class RecommendService {
    private static final Logger LOG = LogManager.getLogger(RecommendService.class);
    private static final String SOLR_ID_FIELD = "europeana_id";
    private RecommendSettings config;
    private WebClient searchApiClient;
    private WebClient rengineClient;

    public RecommendService(RecommendSettings config, WebClients webClients) {
        this.config = config;
        this.searchApiClient = webClients.getSearchApiClient();
        this.rengineClient = webClients.getRecommendEngineClient();
    }

    public Mono getRecommendationsForSet(String setId, int pageSize, String token, String apikey) {
        StringBuilder s = new StringBuilder(this.config.getREngineRecommendPath()).append("?bucket=").append(setId).append("&size=").append(pageSize);
        String[] recommendedIds = (String[])this.getRecommendations(s.toString(), token, apikey).block();
        if (recommendedIds == null || recommendedIds.length == 0) {
            LOG.warn("No recommended records for set {}", (Object)setId);
            return null;
        }
        LOG.debug("Recommend engine returned {} items for set {}", (Object)recommendedIds.length, (Object)setId);
        return this.getSearchApiResponse(recommendedIds, pageSize, apikey);
    }

    public Mono getRecommendationsForRecord(String recordId, int pageSize, String token, String apikey) {
        StringBuilder s = new StringBuilder(this.config.getREngineRecommendPath()).append("?item=").append(recordId).append("&size=").append(pageSize);
        String[] recommendedIds = (String[])this.getRecommendations(s.toString(), token, apikey).block();
        if (recommendedIds == null || recommendedIds.length == 0) {
            LOG.warn("No recommended records for record {}", (Object)recordId);
            return null;
        }
        LOG.debug("Recommend engine returned {} items for record {}", (Object)recommendedIds.length, (Object)recordId);
        return this.getSearchApiResponse(recommendedIds, pageSize, apikey);
    }

    private Mono<String[]> getRecommendations(String recommendQuery, String token, String apikey) {
        Object authValue = token;
        if (StringUtils.isBlank((String)authValue)) {
            authValue = "APIKEY " + apikey;
        }
        return this.rengineClient.get().uri(recommendQuery, new Object[0]).header("Accept", new String[]{"application/json"}).header("Authorization", new String[]{authValue}).retrieve().bodyToMono(String[].class);
    }

    private Mono<Object> getSearchApiResponse(String[] recordIds, int maxResults, String wskey) {
        String query = this.generateSearchQuery(recordIds, maxResults, wskey);
        return this.searchApiClient.get().uri(query, new Object[0]).header("Accept", new String[]{"application/json"}).retrieve().bodyToMono(Object.class);
    }

    private String generateSearchQuery(String[] recordIds, int maxResults, String wskey) {
        StringBuilder s = new StringBuilder(50).append("?query=");
        for (int i = 0; i < maxResults && i < recordIds.length; ++i) {
            if (i > 0) {
                s.append(" OR ");
            }
            s.append(SOLR_ID_FIELD).append(":").append("\"").append(recordIds[i]).append("\"");
        }
        s.append("&rows=").append(recordIds.length).append("&profile=minimal").append("&wskey=").append(wskey);
        return s.toString();
    }
}

