/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.recommend.config;

import eu.europeana.api.recommend.config.BuildInfo;
import eu.europeana.api.recommend.config.RecommendSettings;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class WebClients {
    private static final Logger LOG = LogManager.getLogger(WebClients.class);
    private RecommendSettings config;
    private BuildInfo buildInfo;

    public WebClients(RecommendSettings config, BuildInfo buildInfo) {
        this.config = config;
        this.buildInfo = buildInfo;
    }

    @Bean
    public WebClient getSearchApiClient() {
        return WebClient.builder().baseUrl(this.config.getSearchApiEndpoint()).defaultHeader("User-Agent", new String[]{this.generateUserAgentName()}).filter(this.logRequest()).build();
    }

    @Bean
    public WebClient getRecommendEngineClient() {
        return WebClient.builder().baseUrl(this.config.getREngineHost()).defaultHeader("User-Agent", new String[]{this.generateUserAgentName()}).filter(this.logRequest()).build();
    }

    private String generateUserAgentName() {
        return this.buildInfo.getAppName() + " v" + this.buildInfo.getAppVersion();
    }

    private ExchangeFilterFunction logRequest() {
        return (clientRequest, next) -> {
            LOG.debug("Request: {} {}", (Object)clientRequest.method(), (Object)clientRequest.url());
            return next.exchange(clientRequest);
        };
    }
}

