/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.api.search.syntax.exception.DeserializationException;
import eu.europeana.api.search.syntax.function.FunctionClass;
import eu.europeana.api.search.syntax.function.FunctionRegistry;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionInfoDeserializer
extends JsonDeserializer<FunctionRegistry> {
    public static final String CLASSNAME = "classname";
    private final Logger log = LogManager.getLogger(FunctionInfoDeserializer.class);

    public FunctionRegistry deserialize(JsonParser p, DeserializationContext ctxt) {
        FunctionRegistry registry = FunctionRegistry.INSTANCE;
        try {
            int functionCount = 0;
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            JsonNode functionNode = tree.findValue("function");
            if (functionNode != null && !functionNode.isEmpty()) {
                for (JsonNode node : functionNode) {
                    String classname;
                    if (node.get(CLASSNAME) == null || !StringUtils.isNotBlank((CharSequence)(classname = node.get(CLASSNAME).textValue()))) continue;
                    Class<?> functionClass = Class.forName(classname);
                    Constructor<?> cons = functionClass.getConstructor(new Class[0]);
                    registry.addFunction((FunctionClass)cons.newInstance(new Object[0]));
                    ++functionCount;
                }
                this.log.info("FunctionRegistry -> Total {} function classes loaded in registry!!", (Object)functionCount);
            }
        }
        catch (Exception e) {
            throw new DeserializationException(String.format("Exception occurred while loading %s. %s", "FunctionRegistry.xml", e));
        }
        return registry;
    }
}

