/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import eu.europeana.api.search.syntax.exception.DeserializationException;
import eu.europeana.api.search.syntax.field.FieldDeclaration;
import eu.europeana.api.search.syntax.field.FieldRegistry;
import eu.europeana.api.search.syntax.field.FieldType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldInfoDeserializer
extends JsonDeserializer<FieldRegistry> {
    private final Logger log = LogManager.getLogger(FieldInfoDeserializer.class);

    public FieldRegistry deserialize(JsonParser p, DeserializationContext ctxt) {
        FieldRegistry fieldRegistry = FieldRegistry.INSTANCE;
        try {
            int count = 0;
            ObjectNode tree = (ObjectNode)p.readValueAsTree();
            JsonNode field = tree.findValue("field");
            if (field != null && !field.isEmpty()) {
                for (JsonNode node : field) {
                    fieldRegistry.addField(new FieldDeclaration(node.get("name").textValue(), FieldType.getEnumByValue(node.get("type").textValue()), node.get("searching").textValue(), node.get("faceting").textValue(), node.get("sorting-descending").textValue(), node.get("sorting-ascending").textValue()));
                    ++count;
                }
                this.log.info("FieldRegistry -> Total {} field details loaded in registry!!", (Object)count);
            }
        }
        catch (Exception e) {
            throw new DeserializationException(String.format("Exception occurred while loading %s. %s", "FieldRegistry.xml", e));
        }
        return fieldRegistry;
    }
}

