/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.model;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.function.FunctionClass;
import eu.europeana.api.search.syntax.model.ArgumentExpression;
import eu.europeana.api.search.syntax.model.ExpressionModelVisitor;
import eu.europeana.api.search.syntax.model.TopLevelExpression;
import eu.europeana.api.search.syntax.validation.SyntaxErrorUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class FunctionExpression
implements TopLevelExpression,
ArgumentExpression {
    private FunctionClass function;
    private List<ArgumentExpression> paramList;

    public FunctionExpression(FunctionClass function) {
        this.function = function;
        this.paramList = Collections.emptyList();
    }

    public FunctionExpression(FunctionClass function, List<ArgumentExpression> params) {
        this.function = function;
        this.paramList = params != null ? params : Collections.emptyList();
    }

    public FunctionExpression(FunctionClass function, ArgumentExpression ... params) {
        this.function = function;
        this.paramList = params != null ? Arrays.asList(params) : Collections.emptyList();
    }

    public FunctionClass getFunction() {
        return this.function;
    }

    public List<ArgumentExpression> getParameters() {
        return this.paramList;
    }

    @Override
    public void visit(ExpressionModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toSolr(ConverterContext context) {
        context.push(this);
        try {
            this.validateArgs();
            String string = this.function.toSolr(this, context);
            return string;
        }
        finally {
            context.pop();
        }
    }

    public void validateArgs() {
        int args;
        List<ArgumentExpression> params = this.paramList;
        int size = params.size();
        if (size < (args = this.function.getArgumentNr())) {
            SyntaxErrorUtils.newMissingFunctionArg(this.function.getName(), args, size);
        }
    }

    public String toString() {
        return "FunctionExpression{function=" + String.valueOf(this.function) + ", paramList=" + String.valueOf(this.paramList) + "}";
    }
}

