/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.function;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.function.DateFunction;
import eu.europeana.api.search.syntax.function.FunctionClass;
import eu.europeana.api.search.syntax.model.ArgumentExpression;
import eu.europeana.api.search.syntax.model.FunctionExpression;
import eu.europeana.api.search.syntax.validation.SyntaxValidation;
import java.util.List;

public class IntervalFunction
extends DateFunction
implements FunctionClass {
    public static final String NAME = "interval";
    private static String solrIntervalQuery = "[%s TO %s]";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String toSolr(FunctionExpression expr, ConverterContext context) {
        List<ArgumentExpression> params = expr.getParameters();
        ArgumentExpression arg1 = params.get(0);
        ArgumentExpression arg2 = params.get(1);
        SyntaxValidation.checkArgumentNotFunction("1st", expr, arg1);
        SyntaxValidation.checkArgumentNotFunction("2nd", expr, arg2);
        return String.format(solrIntervalQuery, this.getDate("1st", arg1, context), this.getDate("2nd", arg2, context));
    }

    @Override
    public String toString() {
        return "IntervalFunction{} " + this.getName();
    }
}

