/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.utils;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.exception.QuerySyntaxException;
import eu.europeana.api.search.syntax.field.FieldDeclaration;
import eu.europeana.api.search.syntax.field.FieldMode;
import eu.europeana.api.search.syntax.field.FieldRegistry;
import eu.europeana.api.search.syntax.field.FieldType;
import eu.europeana.api.search.syntax.function.FunctionRegistry;
import eu.europeana.api.search.syntax.model.SyntaxExpression;
import eu.europeana.api.search.syntax.model.ValueExpression;
import eu.europeana.api.search.syntax.parser.SearchExpressionParser;
import eu.europeana.api.search.syntax.utils.FieldInfoDeserializer;
import eu.europeana.api.search.syntax.utils.FunctionInfoDeserializer;
import eu.europeana.api.search.syntax.validation.SyntaxErrorUtils;
import eu.europeana.api.search.syntax.validation.SyntaxValidation;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ParserUtils {
    static Logger log = LogManager.getLogger(ParserUtils.class);

    private ParserUtils() {
    }

    public static Map<String, List<String>> getParsedParametersMap(String[] queryStringArray) {
        HashMap<String, List<String>> paramTovalueMap = new HashMap<String, List<String>>();
        if (queryStringArray != null && queryStringArray.length > 0) {
            Set<Map.Entry<String, List<String>>> set = ParserUtils.parseQueryFilter(queryStringArray);
            set.forEach(entry -> paramTovalueMap.put((String)entry.getKey(), (List)entry.getValue()));
        }
        return paramTovalueMap;
    }

    public static Map<String, List<String>> getParsedParametersMap(String queryStringArray) {
        return ParserUtils.getParsedParametersMap(new String[]{queryStringArray});
    }

    public static Set<Map.Entry<String, List<String>>> parseQueryFilter(String[] queryStringArray) throws QuerySyntaxException {
        ConverterContext context = new ConverterContext();
        ArrayList<String> solrFormat = new ArrayList<String>();
        for (String nqf : queryStringArray) {
            SyntaxExpression expr = ParserUtils.getParsedModel(nqf);
            solrFormat.add(expr != null ? expr.toSolr(context) : null);
            context.setParameter("parsed_param", solrFormat);
        }
        return context.getParameters();
    }

    private static SyntaxExpression getParsedModel(String queryString) throws QuerySyntaxException {
        try {
            SearchExpressionParser parser = new SearchExpressionParser(new StringReader(queryString));
            return parser.parse();
        }
        catch (Exception ex) {
            throw new QuerySyntaxException("Exception : Unable to Parse " + queryString + " " + ex.getMessage());
        }
        catch (Error ex) {
            throw new QuerySyntaxException("Error : Unable to Parse " + queryString + " " + ex.getMessage());
        }
    }

    public static void loadFieldRegistryFromResource(String fileToLoad) {
        try {
            if (!FieldRegistry.INSTANCE.isLoaded) {
                log.info("Loading field Registry !");
                InputStream inputStream = ParserUtils.class.getClassLoader().getResourceAsStream(fileToLoad);
                XmlMapper xmlMapper = ParserUtils.getXmlMapper(FieldRegistry.class, new FieldInfoDeserializer());
                xmlMapper.readValue(inputStream, FieldRegistry.class);
                FieldRegistry.INSTANCE.isLoaded = true;
            }
        }
        catch (IOException ex) {
            log.error(String.format("query-parser -> Error while loading fieldRegistry. %s", ex.getMessage()));
        }
    }

    private static XmlMapper getXmlMapper(Class<?> type, JsonDeserializer deserializer) {
        JacksonXmlModule module = new JacksonXmlModule();
        module.addDeserializer(type, deserializer);
        XmlMapper xmlMapper = new XmlMapper(module);
        xmlMapper.registerModule((Module)module);
        return xmlMapper;
    }

    public static void loadFunctionRegistry(String fileToLoad) {
        try {
            if (!FunctionRegistry.INSTANCE.isLoaded) {
                log.info("Loading function Registry !");
                InputStream inputStream = ParserUtils.class.getClassLoader().getResourceAsStream(fileToLoad);
                XmlMapper xmlMapper = ParserUtils.getXmlMapper(FunctionRegistry.class, new FunctionInfoDeserializer());
                xmlMapper.readValue(inputStream, FunctionRegistry.class);
                FunctionRegistry.INSTANCE.isLoaded = true;
            }
        }
        catch (IOException ex) {
            log.error(String.format("query-parser -> Error while loading functionRegistry. %s", ex.getMessage()));
        }
    }

    public static String getValidFieldFromRegistry(ValueExpression valExpr, ConverterContext context, FieldType type, FieldMode mode) {
        String value = valExpr.getValue();
        FieldDeclaration field = context.getField(value);
        SyntaxValidation.checkFieldType(field, type);
        return ParserUtils.getFiledNameForSpecificMode(mode, field);
    }

    public static String getFiledNameForSpecificMode(FieldMode mode, FieldDeclaration field) {
        if (field != null) {
            String filedNameBasedOnMode = field.getField(mode);
            if (!StringUtils.isNotBlank((CharSequence)filedNameBasedOnMode)) {
                SyntaxErrorUtils.newUnknownFieldNameForMode(mode.toString(), field.getName());
            }
            return field.getField(mode);
        }
        return null;
    }

    public String getFieldNameBasedOnModeForSearchField(String term, FieldMode mode) {
        Map<String, FieldDeclaration> registry = FieldRegistry.INSTANCE.registry;
        for (Map.Entry<String, FieldDeclaration> e : registry.entrySet()) {
            FieldDeclaration decl = e.getValue();
            if (!term.equals(decl.getName())) continue;
            return decl.getField(mode);
        }
        return null;
    }
}

