/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.model;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.field.FieldDeclaration;
import eu.europeana.api.search.syntax.field.FieldMode;
import eu.europeana.api.search.syntax.model.ExpressionModelVisitor;
import eu.europeana.api.search.syntax.model.FieldArgumentExpression;
import eu.europeana.api.search.syntax.model.TopLevelExpression;

public class FieldQueryExpression
implements TopLevelExpression {
    private FieldDeclaration field;
    private FieldArgumentExpression value;

    public FieldQueryExpression(FieldDeclaration field, FieldArgumentExpression value) {
        this.field = field;
        this.value = value;
    }

    public FieldDeclaration getField() {
        return this.field;
    }

    public void setField(FieldDeclaration field) {
        this.field = field;
    }

    public FieldArgumentExpression getValue() {
        return this.value;
    }

    public void setValue(FieldArgumentExpression value) {
        this.value = value;
    }

    @Override
    public void visit(ExpressionModelVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toSolr(ConverterContext context) {
        context.push(this);
        try {
            if (context.getIsToSurroundWithFilterFunction()) {
                String string = "filter(" + this.field.getField(FieldMode.SEARCH) + ":" + this.value.toSolr(context) + ")";
                return string;
            }
            String string = this.field.getField(FieldMode.SEARCH) + ":" + this.value.toSolr(context);
            return string;
        }
        finally {
            context.pop();
        }
    }
}

