/*
 * Decompiled with CFR 0.152.
 */
package eu.europeana.api.search.syntax.model;

import eu.europeana.api.search.syntax.converter.ConverterContext;
import eu.europeana.api.search.syntax.model.SetExpression;
import eu.europeana.api.search.syntax.model.TopLevelExpression;

public abstract class BinaryArgumentExpression
implements SetExpression {
    private TopLevelExpression left;
    private TopLevelExpression right;

    public BinaryArgumentExpression(TopLevelExpression left, TopLevelExpression right) {
        this.left = left;
        this.right = right;
    }

    public TopLevelExpression getLeft() {
        return this.left;
    }

    public TopLevelExpression getRight() {
        return this.right;
    }

    public void setLeft(TopLevelExpression left) {
        this.left = left;
    }

    public void setRight(TopLevelExpression right) {
        this.right = right;
    }

    public abstract String getOperator();

    @Override
    public String toSolr(ConverterContext context) {
        context.push(this);
        context.setIsToSurroundWithFilterFunction(true);
        try {
            String string = "(" + this.getLeft().toSolr(context) + this.getOperator() + this.getRight().toSolr(context) + ")";
            return string;
        }
        finally {
            context.setIsToSurroundWithFilterFunction(false);
            context.pop();
        }
    }
}

